/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.parser.io;

import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogLineFilter {
    private static final Logger LOGGER = Logger.getLogger(LogLineFilter.class.getName());
    private static final String PREFIX_FILTER_PROPERTY = "com.microsoft.gctoolkit.filter";
    private static final String VERBOSE_PROPERTY = "com.microsoft.gctoolkit.verbose.log";
    private static boolean verbose = false;
    private static String prefixFilter = null;
    private Pattern filterPattern = null;

    public LogLineFilter() {
        if (prefixFilter != null) {
            if (!prefixFilter.startsWith("^")) {
                prefixFilter = "^" + prefixFilter;
            }
            this.filterPattern = Pattern.compile(prefixFilter + "(.+)");
        }
    }

    public String prefixFilter(String line) {
        if (verbose) {
            LOGGER.fine(line);
        }
        if (this.filterPattern == null) {
            return line;
        }
        try {
            Matcher matcher = this.filterPattern.matcher(line);
            if (matcher.find()) {
                return matcher.group(1);
            }
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, t.getMessage(), LOGGER);
        }
        return line;
    }

    static {
        prefixFilter = System.getProperty(PREFIX_FILTER_PROPERTY);
        verbose = Boolean.getBoolean(VERBOSE_PROPERTY);
    }
}

