/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.parser.io;

import com.microsoft.gctoolkit.io.DataSource;
import com.microsoft.gctoolkit.io.LogFileMetadata;
import com.microsoft.gctoolkit.jvm.Diary;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class SafepointLogFile
implements DataSource<String> {
    private final LogFileMetadata metadata = null;
    private final Path path;

    public SafepointLogFile(Path path) {
        this.path = path;
    }

    public Diary diary() {
        return new Diary();
    }

    public String endOfData() {
        return "END_OF_DATA_SENTINEL";
    }

    public Path getPath() {
        return this.path;
    }

    public Stream<String> stream() throws IOException {
        if (this.metadata.isPlainText()) {
            return Files.lines(this.path);
        }
        if (this.metadata.isZip()) {
            return this.streamZipFile();
        }
        if (this.metadata.isGZip()) {
            return this.streamGZipFile();
        }
        throw new IOException("Unable to read " + this.path.toString());
    }

    Stream<String> streamZipFile() throws IOException {
        ZipEntry entry;
        ZipInputStream zipStream = new ZipInputStream(Files.newInputStream(this.path, new OpenOption[0]));
        while ((entry = zipStream.getNextEntry()).isDirectory()) {
        }
        return new BufferedReader(new InputStreamReader(new BufferedInputStream(zipStream))).lines();
    }

    Stream<String> streamGZipFile() throws IOException {
        GZIPInputStream gzipStream = new GZIPInputStream(Files.newInputStream(this.path, new OpenOption[0]));
        return new BufferedReader(new InputStreamReader(new BufferedInputStream(gzipStream))).lines();
    }
}

