/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.parser.vmops;

import com.microsoft.gctoolkit.aggregator.EventSource;
import com.microsoft.gctoolkit.event.jvm.JVMEvent;
import com.microsoft.gctoolkit.event.jvm.JVMTermination;
import com.microsoft.gctoolkit.event.jvm.Safepoint;
import com.microsoft.gctoolkit.jvm.Diary;
import com.microsoft.gctoolkit.message.ChannelName;
import com.microsoft.gctoolkit.message.JVMEventChannel;
import com.microsoft.gctoolkit.parser.PreUnifiedGCLogParser;
import com.microsoft.gctoolkit.parser.vmops.SafepointPatterns;
import com.microsoft.gctoolkit.parser.vmops.SafepointTrace;
import java.util.Set;

public class SafepointParser
extends PreUnifiedGCLogParser
implements SafepointPatterns {
    public Set<EventSource> eventsProduced() {
        return Set.of(EventSource.SAFEPOINT);
    }

    @Override
    public String getName() {
        return "SafepointParser";
    }

    @Override
    protected void process(String line) {
        SafepointTrace trace = TRACE.parse(line);
        if (trace != null) {
            Safepoint safepoint = trace.toSafepoint();
            super.publish(ChannelName.JVM_EVENT_PARSER_OUTBOX, (JVMEvent)safepoint);
        } else if (line.equals("END_OF_DATA_SENTINEL")) {
            super.publish(ChannelName.JVM_EVENT_PARSER_OUTBOX, (JVMEvent)new JVMTermination(this.getClock(), this.diary.getTimeOfFirstEvent()));
        }
    }

    public boolean accepts(Diary diary) {
        return (diary.isTLABData() || diary.isApplicationStoppedTime() || diary.isApplicationRunningTime()) && !diary.isUnifiedLogging();
    }

    @Override
    public void publishTo(JVMEventChannel bus) {
        super.publishTo(bus);
    }
}

