/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.parser.vmops;

import com.microsoft.gctoolkit.event.jvm.Safepoint;
import com.microsoft.gctoolkit.parser.AbstractLogTrace;
import com.microsoft.gctoolkit.time.DateTimeStamp;
import java.util.regex.Matcher;

public class SafepointTrace
extends AbstractLogTrace {
    private final int TIME_STAMP = 1;
    private final int VMOP = 2;
    private final int TOTAL_THREADS = 3;
    private final int INITIALLY_RUNNING_THREADS = 4;
    private final int WAITING_TO_BLOCK = 5;
    private final int SPIN_TIME = 6;
    private final int BLOCK_TIME = 7;
    private final int SYNC_TIME = 8;
    private final int CLEANUP_TIME = 9;
    private final int VMOP_TIME = 10;
    private final int TRAP_COUNT = 11;

    public SafepointTrace(Matcher matcher) {
        super(matcher);
    }

    public Safepoint toSafepoint() {
        Safepoint safepoint = new Safepoint(this.getVMOP(), this.getDateTimeStamp(), this.getDuration());
        safepoint.recordThreadCounts(this.totalThreads(), this.initiallyRunningThreads(), this.waitingToBlockThreads());
        safepoint.recordDurations(this.spinTime(), this.blockTime(), this.syncTime(), this.cleanupTime(), this.vmopTime());
        safepoint.recordPageTrapCount(this.getTrapCount());
        return safepoint;
    }

    public String getVMOP() {
        return super.getGroup(2);
    }

    @Override
    public DateTimeStamp getDateTimeStamp() {
        return new DateTimeStamp(this.getTimeStampGroup());
    }

    public double getDuration() {
        return (double)(this.spinTime() + this.blockTime() + this.syncTime() + this.cleanupTime() + this.vmopTime()) / 1000.0;
    }

    public int totalThreads() {
        return this.getIntegerGroup(3);
    }

    public int initiallyRunningThreads() {
        return this.getIntegerGroup(4);
    }

    public int waitingToBlockThreads() {
        return this.getIntegerGroup(5);
    }

    public int spinTime() {
        return this.getIntegerGroup(6);
    }

    public int blockTime() {
        return this.getIntegerGroup(7);
    }

    public int syncTime() {
        return this.getIntegerGroup(8);
    }

    public int cleanupTime() {
        return this.getIntegerGroup(9);
    }

    public int vmopTime() {
        return this.getIntegerGroup(10);
    }

    public int getTrapCount() {
        return this.getIntegerGroup(11);
    }

    private double getTimeStampGroup() {
        return this.getDoubleGroup(1);
    }
}

