/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.vertx;

import com.microsoft.gctoolkit.event.jvm.JVMEvent;
import com.microsoft.gctoolkit.event.jvm.JVMTermination;
import com.microsoft.gctoolkit.io.DataSource;
import com.microsoft.gctoolkit.time.DateTimeStamp;
import com.microsoft.gctoolkit.vertx.JVMEventSource;
import com.microsoft.gctoolkit.vertx.aggregator.AggregatorVerticle;
import com.microsoft.gctoolkit.vertx.io.JVMEventCodec;
import com.microsoft.gctoolkit.vertx.jvm.LogFileParser;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.MessageCodec;
import java.io.IOException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GCToolkitVertx
extends AbstractVerticle {
    private static final Logger LOGGER = Logger.getLogger(GCToolkitVertx.class.getName());
    public static final String PARSER_INBOX = "PARSER";
    public static final String JVM_EVENT_PARSER_OUTBOX = "JVMEventParser";
    public static final String SURVIVOR_MEMORY_POOL_PARSER_OUTBOX = "SurvivorMemoryPoolParser";
    public static final String GENERATIONAL_HEAP_PARSER_OUTBOX = "GenerationalHeapParser";
    public static final String CMS_TENURED_POOL_PARSER_OUTBOX = "CMSTenuredPoolParser";
    public static final String G1GC_PARSER_OUTBOX = "G1GCParser";
    public static final String ZGC_PARSER_OUTBOX = "ZGCParser";
    public static final String SHENANDOAH_PARSER_OUTBOX = "ShenandoahParser";
    private final String mailBox;
    private final Vertx vertx;
    private DateTimeStamp timeOfLastEvent = new DateTimeStamp(0.0);

    public static void disableCaching() {
        System.setProperty("vertx.disableFileCPResolving", "true");
        System.setProperty("vertx.disableFileCaching", "true");
    }

    private GCToolkitVertx(String mailBox) {
        GCToolkitVertx.disableCaching();
        this.mailBox = mailBox;
        this.vertx = Vertx.vertx();
        this.vertx.eventBus().registerDefaultCodec(JVMEvent.class, (MessageCodec)new JVMEventCodec());
    }

    public void shutdown() {
        this.vertx.close();
    }

    public static DateTimeStamp aggregateDataSource(DataSource<?> dataSource, Set<LogFileParser> logFileParsers, Set<AggregatorVerticle> aggregatorVerticles, String mailBox) throws IOException {
        aggregatorVerticles.removeIf(aggregatorVerticle -> {
            boolean isMatch = logFileParsers.stream().map(LogFileParser::getOutbox).anyMatch(outbox -> outbox.equals(aggregatorVerticle.getInbox()));
            if (!isMatch) {
                LOGGER.log(Level.SEVERE, String.format("Remove %s %s", aggregatorVerticle.getInbox(), aggregatorVerticle));
            }
            return !isMatch;
        });
        GCToolkitVertx gcToolkitVertx = new GCToolkitVertx(mailBox);
        JVMEventSource jvmEventSource = new JVMEventSource(PARSER_INBOX);
        gcToolkitVertx.deployVerticle((Verticle)jvmEventSource);
        jvmEventSource.awaitDeployment();
        gcToolkitVertx.deployVerticle((Verticle)gcToolkitVertx);
        logFileParsers.forEach(logFileParser -> gcToolkitVertx.deployVerticle((Verticle)logFileParser, new DeploymentOptions().setWorker(true)));
        logFileParsers.forEach(LogFileParser::awaitDeployment);
        aggregatorVerticles.forEach(gcToolkitVertx::deployVerticle);
        aggregatorVerticles.forEach(AggregatorVerticle::awaitDeployment);
        jvmEventSource.publishGCDataSource(dataSource);
        aggregatorVerticles.forEach(AggregatorVerticle::awaitCompletion);
        gcToolkitVertx.shutdown();
        return gcToolkitVertx.timeOfLastEvent;
    }

    private Future<String> deployVerticle(Verticle verticle) {
        return this.vertx.deployVerticle(verticle);
    }

    private Future<String> deployVerticle(Verticle verticle, DeploymentOptions deploymentOptions) {
        return this.vertx.deployVerticle(verticle, deploymentOptions);
    }

    public void start() {
        try {
            this.vertx.eventBus().consumer(this.mailBox, message -> {
                try {
                    JVMEvent event = (JVMEvent)message.body();
                    DateTimeStamp now = event.getDateTimeStamp().add(event.getDuration());
                    if (now.after(this.timeOfLastEvent)) {
                        this.timeOfLastEvent = now;
                    }
                    if (event instanceof JVMTermination) {
                        return;
                    }
                }
                catch (Throwable t) {
                    LOGGER.throwing(((Object)((Object)this)).getClass().getName(), "start", t);
                }
            });
        }
        catch (Throwable t) {
            LOGGER.throwing(((Object)((Object)this)).getClass().getName(), "start", t);
        }
    }

    static {
        GCToolkitVertx.disableCaching();
    }
}

