/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.vertx;

import com.microsoft.gctoolkit.io.DataSource;
import com.microsoft.gctoolkit.parser.io.SafepointLogFile;
import com.microsoft.gctoolkit.vertx.internal.util.concurrent.StartingGun;
import io.vertx.core.AbstractVerticle;
import java.io.IOException;
import java.nio.file.Path;

public class JVMEventSource
extends AbstractVerticle {
    private final String publicationChannel;
    private final StartingGun deployed = new StartingGun();

    public JVMEventSource(String publicationChannel) {
        this.publicationChannel = publicationChannel;
    }

    public void publishGCDataSource(DataSource<?> dataSource) throws IOException {
        dataSource.stream().forEach(entry -> this.vertx.eventBus().publish(this.publicationChannel, entry));
        this.vertx.eventBus().publish(this.publicationChannel, dataSource.endOfData());
    }

    public void publishSafePointLogFile(Path logFile) throws IOException {
        SafepointLogFile safepointLogFile = new SafepointLogFile(logFile);
        safepointLogFile.stream().forEach(entry -> this.vertx.eventBus().publish(this.publicationChannel, entry));
        this.vertx.eventBus().publish(this.publicationChannel, (Object)safepointLogFile.endOfData());
    }

    public void awaitDeployment() {
        this.deployed.awaitUninterruptibly();
    }

    public void start() {
        this.deployed.ready();
    }
}

