/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.vertx.aggregator;

import com.microsoft.gctoolkit.aggregator.Aggregation;
import com.microsoft.gctoolkit.aggregator.Aggregator;
import com.microsoft.gctoolkit.event.jvm.JVMEvent;
import com.microsoft.gctoolkit.event.jvm.JVMTermination;
import com.microsoft.gctoolkit.time.DateTimeStamp;
import com.microsoft.gctoolkit.vertx.internal.util.concurrent.StartingGun;
import io.vertx.core.AbstractVerticle;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AggregatorVerticle
extends AbstractVerticle {
    private static final Logger LOGGER = Logger.getLogger(AggregatorVerticle.class.getName());
    private final Set<Aggregator<?>> aggregators = new HashSet();
    private final StartingGun deployed = new StartingGun();
    private final StartingGun completion = new StartingGun();
    private volatile DateTimeStamp timeOfTerminationEvent;
    private final String inbox;

    public AggregatorVerticle(String inbox) {
        this.inbox = inbox;
    }

    public String getInbox() {
        return this.inbox;
    }

    public boolean equals(Object other) {
        return this == other;
    }

    public int hashCode() {
        return System.identityHashCode((Object)this);
    }

    public void registerAggregator(Aggregator<?> aggregator) {
        this.aggregators.add(new AggregatorWrapper(aggregator));
    }

    public Set<Aggregator<?>> aggregators() {
        return this.aggregators;
    }

    public void record(JVMEvent event) {
        this.aggregators.forEach(aggregator -> {
            try {
                aggregator.consume(event);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Error in aggregator", e);
            }
        });
    }

    public void awaitDeployment() {
        this.deployed.awaitUninterruptibly();
    }

    public DateTimeStamp awaitCompletion() {
        this.completion.awaitUninterruptibly();
        return this.timeOfTerminationEvent;
    }

    private void monitorForTermination() {
        Executors.newSingleThreadExecutor().execute(() -> this.completion.awaitUninterruptibly());
    }

    public void start() {
        try {
            this.monitorForTermination();
            this.vertx.eventBus().consumer(this.inbox, message -> {
                try {
                    JVMEvent event = (JVMEvent)message.body();
                    this.record(event);
                    if (event instanceof JVMTermination) {
                        this.timeOfTerminationEvent = event.getDateTimeStamp();
                        this.completion.ready();
                    }
                }
                catch (Throwable t) {
                    LOGGER.throwing(((Object)((Object)this)).getClass().getName(), "start", t);
                }
            });
            this.deployed.ready();
        }
        catch (Throwable t) {
            LOGGER.throwing(((Object)((Object)this)).getClass().getName(), "start", t);
        }
    }

    private static class AggregatorWrapper
    extends Aggregator<Aggregation> {
        private final Aggregator<?> proxy;
        private Runnable completionHandler;

        private AggregatorWrapper(Aggregator<?> proxy) {
            super(null);
            this.proxy = proxy;
        }

        public Aggregation aggregation() {
            return this.proxy.aggregation();
        }

        public <E extends JVMEvent> void consume(E event) {
            this.proxy.consume(event);
            if (this.isDone() && this.completionHandler != null) {
                this.completionHandler.run();
            }
        }

        public boolean isDone() {
            return this.proxy.isDone();
        }

        public void onCompletion(Runnable runnable) {
            this.completionHandler = runnable;
            if (this.isDone()) {
                runnable.run();
            }
        }
    }
}

