/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.vertx.jvm;

import com.microsoft.gctoolkit.aggregator.Aggregation;
import com.microsoft.gctoolkit.io.DataSource;
import com.microsoft.gctoolkit.io.GCLogFile;
import com.microsoft.gctoolkit.jvm.Diary;
import com.microsoft.gctoolkit.jvm.JavaVirtualMachine;
import com.microsoft.gctoolkit.time.DateTimeStamp;
import com.microsoft.gctoolkit.vertx.GCToolkitVertx;
import com.microsoft.gctoolkit.vertx.jvm.GCToolkitVertxParameters;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractJavaVirtualMachine
implements JavaVirtualMachine {
    private static final Logger LOGGER = Logger.getLogger(AbstractJavaVirtualMachine.class.getName());
    private static final double LOG_FRAGMENT_THRESHOLD_SECONDS = 60.0;
    private Diary diary;
    private DateTimeStamp timeOfLastEvent;
    private final Map<Class<? extends Aggregation>, Aggregation> aggregatedData = new ConcurrentHashMap<Class<? extends Aggregation>, Aggregation>();

    public boolean isG1GC() {
        return this.diary.isG1GC();
    }

    public boolean isZGC() {
        return this.diary.isZGC();
    }

    public boolean isShenandoah() {
        return this.diary.isShenandoah();
    }

    public boolean isParallel() {
        return this.diary.isPSYoung();
    }

    public boolean isSerial() {
        return this.diary.isSerialFull();
    }

    public boolean isCMS() {
        return this.diary.isCMS();
    }

    public String getCommandLine() {
        return "";
    }

    public DateTimeStamp getTimeOfFirstEvent() {
        return this.diary.getTimeOfFirstEvent();
    }

    public DateTimeStamp getEstimatedJVMStartTime() {
        DateTimeStamp startTime = this.diary.getTimeOfFirstEvent();
        if (startTime.getTimeStamp() < 60.0) {
            return startTime.minus(startTime.getTimeStamp());
        }
        return startTime;
    }

    public DateTimeStamp getJVMTerminationTime() {
        return this.timeOfLastEvent;
    }

    public double getRuntimeDuration() {
        return this.getJVMTerminationTime().minus(this.getEstimatedJVMStartTime());
    }

    public <T extends Aggregation> Optional<T> getAggregation(Class<T> aggregationClass) {
        return Optional.ofNullable(this.aggregatedData.get(aggregationClass));
    }

    abstract GCToolkitVertxParameters getParameters(Set<Class<? extends Aggregation>> var1, Diary var2);

    public void analyze(Set<Class<? extends Aggregation>> registeredAggregations, DataSource<?> dataSource) {
        try {
            GCLogFile gcLogFile = (GCLogFile)dataSource;
            this.diary = gcLogFile.diary();
            GCToolkitVertxParameters GCToolkitVertxParameters2 = this.getParameters(registeredAggregations, gcLogFile.diary());
            this.timeOfLastEvent = GCToolkitVertx.aggregateDataSource(dataSource, GCToolkitVertxParameters2.logFileParsers(), GCToolkitVertxParameters2.aggregatorVerticles(), GCToolkitVertxParameters2.mailBox());
            GCToolkitVertxParameters2.aggregatorVerticles().stream().flatMap(aggregatorVerticle -> aggregatorVerticle.aggregators().stream()).forEach(aggregator -> {
                Aggregation aggregation = aggregator.aggregation();
                this.aggregatedData.put(aggregation.getClass(), aggregation);
            });
        }
        catch (IOException | ClassCastException e) {
            LOGGER.log(Level.WARNING, e.getMessage(), e);
        }
    }
}

