/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.vertx.jvm;

import com.microsoft.gctoolkit.aggregator.Aggregates;
import com.microsoft.gctoolkit.aggregator.Aggregation;
import com.microsoft.gctoolkit.aggregator.Aggregator;
import com.microsoft.gctoolkit.aggregator.Collates;
import com.microsoft.gctoolkit.aggregator.EventSource;
import com.microsoft.gctoolkit.vertx.aggregator.AggregatorVerticle;
import com.microsoft.gctoolkit.vertx.jvm.LogFileParser;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

abstract class GCToolkitVertxParameters {
    private static final Logger LOGGER = Logger.getLogger(GCToolkitVertxParameters.class.getName());

    GCToolkitVertxParameters() {
    }

    abstract Set<LogFileParser> logFileParsers();

    abstract Set<AggregatorVerticle> aggregatorVerticles();

    abstract String mailBox();

    private static void aggregatorAggregates(Class<?> clazz, Set<EventSource> eventSources) {
        Class<?>[] interfaces;
        Aggregates aggregates;
        if (clazz == null || clazz == Aggregator.class) {
            return;
        }
        if (clazz.isAnnotationPresent(Aggregates.class) && (aggregates = clazz.getAnnotation(Aggregates.class)) != null) {
            Collections.addAll(eventSources, aggregates.value());
        }
        GCToolkitVertxParameters.aggregatorAggregates(clazz.getSuperclass(), eventSources);
        for (Class<?> iface : interfaces = clazz.getInterfaces()) {
            GCToolkitVertxParameters.aggregatorAggregates(iface, eventSources);
        }
    }

    private static Class<? extends Aggregator<?>> getAggregatorClassFromCollatesAnnotation(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAnnotationPresent(Collates.class)) {
            Collates collates = clazz.getAnnotation(Collates.class);
            return collates.value();
        }
        Class<? extends Aggregator<?>> aggregatorClass = GCToolkitVertxParameters.getAggregatorClassFromCollatesAnnotation(clazz.getSuperclass());
        if (aggregatorClass == null) {
            Class<?> iface;
            Class<?>[] interfaces;
            Class<?>[] classArray = interfaces = clazz.getInterfaces();
            int n = classArray.length;
            for (int i = 0; i < n && (aggregatorClass = GCToolkitVertxParameters.getAggregatorClassFromCollatesAnnotation(iface = classArray[i])) == null; ++i) {
            }
        }
        return aggregatorClass;
    }

    private static Aggregator<?> createAggregator(Class<? extends Aggregator<?>> aggregatorClass, Class<? extends Aggregation> aggregationClass) {
        try {
            Constructor<?>[] aggregatorCtors = aggregatorClass.getConstructors();
            Constructor aggregatorCtor = Stream.of(aggregatorCtors).filter(ctor -> ctor.getParameterTypes().length == 1).filter(ctor -> ctor.getParameterTypes()[0].isAssignableFrom(aggregationClass)).findFirst().orElseThrow(() -> new NoSuchMethodException(aggregatorClass + " must have a public constructor which takes a " + Aggregation.class));
            Constructor<? extends Aggregation> aggregationCtor = aggregationClass.getConstructor(new Class[0]);
            Aggregation aggregation = aggregationCtor.newInstance(new Object[0]);
            return (Aggregator)aggregatorCtor.newInstance(aggregation);
        }
        catch (ReflectiveOperationException e) {
            LOGGER.log(Level.WARNING, e + ": Cannot construct instance of " + aggregatorClass);
            return null;
        }
    }

    Set<Aggregator<?>> getAggregators(EventSource eventSource, Set<Class<? extends Aggregation>> registeredAggregations) {
        HashSet aggregators = new HashSet();
        HashSet eventSources = new HashSet();
        registeredAggregations.forEach(aggregationClass -> {
            Aggregator<?> aggregator;
            Class<? extends Aggregator<?>> aggregatorClass = GCToolkitVertxParameters.getAggregatorClassFromCollatesAnnotation(aggregationClass);
            eventSources.clear();
            GCToolkitVertxParameters.aggregatorAggregates(aggregatorClass, eventSources);
            if (eventSources.contains(eventSource) && (aggregator = GCToolkitVertxParameters.createAggregator(aggregatorClass, aggregationClass)) != null) {
                aggregators.add(aggregator);
            }
        });
        return aggregators;
    }
}

