/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.vertx.jvm;

import com.microsoft.gctoolkit.aggregator.Aggregation;
import com.microsoft.gctoolkit.aggregator.Aggregator;
import com.microsoft.gctoolkit.aggregator.EventSource;
import com.microsoft.gctoolkit.jvm.Diary;
import com.microsoft.gctoolkit.parser.CMSTenuredPoolParser;
import com.microsoft.gctoolkit.parser.GenerationalHeapParser;
import com.microsoft.gctoolkit.parser.JVMEventParser;
import com.microsoft.gctoolkit.parser.PreUnifiedG1GCParser;
import com.microsoft.gctoolkit.parser.SurvivorMemoryPoolParser;
import com.microsoft.gctoolkit.vertx.aggregator.AggregatorVerticle;
import com.microsoft.gctoolkit.vertx.jvm.GCToolkitVertxParameters;
import com.microsoft.gctoolkit.vertx.jvm.LogFileParser;
import java.util.HashSet;
import java.util.Set;

class GCToolkitVertxParametersForPreUnifiedLogs
extends GCToolkitVertxParameters {
    public static final String SAFEPOINT_OUTBOX = "SafepointParser";
    private final Set<LogFileParser> logFileParsers;
    private final Set<AggregatorVerticle> aggregatorVerticles;
    private final String mailBox;

    GCToolkitVertxParametersForPreUnifiedLogs(Set<Class<? extends Aggregation>> registeredAggregations, Diary diary) {
        this.logFileParsers = this.initLogFileParsers(diary);
        this.aggregatorVerticles = this.initAggregatorVerticles(registeredAggregations, diary);
        this.mailBox = this.initMailBox(diary);
    }

    @Override
    public Set<LogFileParser> logFileParsers() {
        return this.logFileParsers;
    }

    @Override
    public Set<AggregatorVerticle> aggregatorVerticles() {
        return this.aggregatorVerticles;
    }

    @Override
    public String mailBox() {
        return this.mailBox;
    }

    private Set<LogFileParser> initLogFileParsers(Diary diary) {
        HashSet<LogFileParser> logFileParsers = new HashSet<LogFileParser>();
        if (diary.isApplicationRunningTime() || diary.isApplicationStoppedTime()) {
            logFileParsers.add(new LogFileParser("PARSER", "JVMEventParser", consumer -> new JVMEventParser(diary, consumer)));
            logFileParsers.add(new LogFileParser("PARSER", SAFEPOINT_OUTBOX, consumer -> new JVMEventParser(diary, consumer)));
        }
        if (diary.isTenuringDistribution()) {
            logFileParsers.add(new LogFileParser("PARSER", "SurvivorMemoryPoolParser", consumer -> new SurvivorMemoryPoolParser(diary, consumer)));
        }
        if (diary.isGenerational()) {
            logFileParsers.add(new LogFileParser("PARSER", "GenerationalHeapParser", consumer -> new GenerationalHeapParser(diary, consumer)));
            if (diary.isCMS()) {
                logFileParsers.add(new LogFileParser("PARSER", "CMSTenuredPoolParser", consumer -> new CMSTenuredPoolParser(diary, consumer)));
            }
        }
        if (diary.isG1GC()) {
            logFileParsers.add(new LogFileParser("PARSER", "G1GCParser", consumer -> new PreUnifiedG1GCParser(diary, consumer)));
        }
        if (diary.isZGC()) {
            throw new UnsupportedOperationException("Internal GCToolKit Error: " + this.getClass().getName() + " cannot process ZGC");
        }
        if (diary.isShenandoah()) {
            throw new UnsupportedOperationException("Internal GCToolKit Error: " + this.getClass().getName() + " cannot process Shenandoah");
        }
        return logFileParsers;
    }

    private Set<AggregatorVerticle> initAggregatorVerticles(Set<Class<? extends Aggregation>> registeredAggregations, Diary diary) {
        Set<Aggregator<?>> safepointAggregators;
        AggregatorVerticle aggregatorVerticle;
        Set<Aggregator<?>> aggregators;
        HashSet<AggregatorVerticle> aggregatorVerticles = new HashSet<AggregatorVerticle>();
        if (diary.isG1GC() && (aggregators = this.getAggregators(EventSource.G1GC, registeredAggregations)) != null && !aggregators.isEmpty()) {
            aggregatorVerticle = new AggregatorVerticle("G1GCParser");
            aggregators.forEach(aggregatorVerticle::registerAggregator);
            aggregatorVerticles.add(aggregatorVerticle);
        }
        if (diary.isGenerational()) {
            Set<Aggregator<?>> cmsAggregators;
            aggregators = this.getAggregators(EventSource.GENERATIONAL, registeredAggregations);
            if (aggregators != null && !aggregators.isEmpty()) {
                aggregatorVerticle = new AggregatorVerticle("GenerationalHeapParser");
                aggregators.forEach(aggregatorVerticle::registerAggregator);
                aggregatorVerticles.add(aggregatorVerticle);
            }
            if (diary.isCMS() && (cmsAggregators = this.getAggregators(EventSource.TENURED, registeredAggregations)) != null && !cmsAggregators.isEmpty()) {
                AggregatorVerticle cmsAggregatorVerticle = new AggregatorVerticle("CMSTenuredPoolParser");
                cmsAggregators.forEach(cmsAggregatorVerticle::registerAggregator);
                aggregatorVerticles.add(cmsAggregatorVerticle);
            }
        }
        if (diary.isZGC()) {
            throw new IllegalStateException("Internal GCToolKit Error: " + this.getClass().getName() + " cannot process ZGC");
        }
        if (diary.isShenandoah()) {
            throw new IllegalStateException("Internal GCToolKit Error: " + this.getClass().getName() + " cannot process Shenandoah");
        }
        if (diary.isTenuringDistribution() && (aggregators = this.getAggregators(EventSource.SURVIVOR, registeredAggregations)) != null && !aggregators.isEmpty()) {
            aggregatorVerticle = new AggregatorVerticle("SurvivorMemoryPoolParser");
            aggregators.forEach(aggregatorVerticle::registerAggregator);
            aggregatorVerticles.add(aggregatorVerticle);
        }
        if ((diary.isApplicationRunningTime() || diary.isApplicationStoppedTime()) && (safepointAggregators = this.getAggregators(EventSource.SAFEPOINT, registeredAggregations)) != null && !safepointAggregators.isEmpty()) {
            aggregatorVerticle = new AggregatorVerticle(SAFEPOINT_OUTBOX);
            safepointAggregators.forEach(aggregatorVerticle::registerAggregator);
            aggregatorVerticles.add(aggregatorVerticle);
        }
        return aggregatorVerticles;
    }

    private String initMailBox(Diary diary) {
        if (diary.isG1GC()) {
            return "G1GCParser";
        }
        if (diary.isGenerational()) {
            return diary.isCMS() ? "CMSTenuredPoolParser" : "GenerationalHeapParser";
        }
        if (diary.isZGC()) {
            return "ZGCParser";
        }
        if (diary.isShenandoah()) {
            return "ShenandoahParser";
        }
        return "GenerationalHeapParser";
    }
}

