/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.vertx.jvm;

import com.microsoft.gctoolkit.aggregator.Aggregation;
import com.microsoft.gctoolkit.aggregator.Aggregator;
import com.microsoft.gctoolkit.aggregator.EventSource;
import com.microsoft.gctoolkit.jvm.Diary;
import com.microsoft.gctoolkit.parser.UnifiedG1GCParser;
import com.microsoft.gctoolkit.parser.UnifiedGenerationalParser;
import com.microsoft.gctoolkit.parser.UnifiedJVMEventParser;
import com.microsoft.gctoolkit.parser.UnifiedSurvivorMemoryPoolParser;
import com.microsoft.gctoolkit.parser.ZGCParser;
import com.microsoft.gctoolkit.vertx.aggregator.AggregatorVerticle;
import com.microsoft.gctoolkit.vertx.jvm.GCToolkitVertxParameters;
import com.microsoft.gctoolkit.vertx.jvm.LogFileParser;
import java.util.HashSet;
import java.util.Set;

class GCToolkitVertxParametersForUnifiedLogs
extends GCToolkitVertxParameters {
    private final Set<LogFileParser> logFileParsers;
    private final Set<AggregatorVerticle> aggregatorVerticles;
    private final String mailBox;

    GCToolkitVertxParametersForUnifiedLogs(Set<Class<? extends Aggregation>> registeredAggregations, Diary diary) {
        this.logFileParsers = this.initLogFileParsers(diary);
        this.aggregatorVerticles = this.initAggregatorVerticles(registeredAggregations, diary);
        this.mailBox = this.initMailBox(diary);
    }

    @Override
    public Set<LogFileParser> logFileParsers() {
        return this.logFileParsers;
    }

    @Override
    public Set<AggregatorVerticle> aggregatorVerticles() {
        return this.aggregatorVerticles;
    }

    @Override
    public String mailBox() {
        return this.mailBox;
    }

    private Set<LogFileParser> initLogFileParsers(Diary diary) {
        HashSet<LogFileParser> logFileParsers = new HashSet<LogFileParser>();
        if (diary.isApplicationStoppedTime() || diary.isApplicationRunningTime()) {
            logFileParsers.add(new LogFileParser("PARSER", "JVMEventParser", consumer -> new UnifiedJVMEventParser(diary, consumer)));
        }
        if (diary.isTenuringDistribution()) {
            logFileParsers.add(new LogFileParser("PARSER", "SurvivorMemoryPoolParser", consumer -> new UnifiedSurvivorMemoryPoolParser(diary, consumer)));
        }
        if (diary.isGenerational()) {
            logFileParsers.add(new LogFileParser("PARSER", "GenerationalHeapParser", consumer -> new UnifiedGenerationalParser(diary, consumer)));
        }
        if (diary.isG1GC()) {
            logFileParsers.add(new LogFileParser("PARSER", "G1GCParser", consumer -> new UnifiedG1GCParser(diary, consumer)));
        }
        if (diary.isZGC()) {
            logFileParsers.add(new LogFileParser("PARSER", "ZGCParser", consumer -> new ZGCParser(diary, consumer)));
        }
        if (diary.isShenandoah()) {
            throw new UnsupportedOperationException("Not yet implemented");
        }
        return logFileParsers;
    }

    private Set<AggregatorVerticle> initAggregatorVerticles(Set<Class<? extends Aggregation>> registeredAggregations, Diary diary) {
        AggregatorVerticle aggregatorVerticle;
        Set<Aggregator<?>> aggregators;
        HashSet<AggregatorVerticle> aggregatorVerticles = new HashSet<AggregatorVerticle>();
        if (diary.isG1GC() && (aggregators = this.getAggregators(EventSource.G1GC, registeredAggregations)) != null && !aggregators.isEmpty()) {
            aggregatorVerticle = new AggregatorVerticle("G1GCParser");
            aggregators.forEach(aggregatorVerticle::registerAggregator);
            aggregatorVerticles.add(aggregatorVerticle);
        }
        if (diary.isGenerational() && (aggregators = this.getAggregators(EventSource.GENERATIONAL, registeredAggregations)) != null && !aggregators.isEmpty()) {
            aggregatorVerticle = new AggregatorVerticle("GenerationalHeapParser");
            aggregators.forEach(aggregatorVerticle::registerAggregator);
            aggregatorVerticles.add(aggregatorVerticle);
        }
        if (diary.isShenandoah() && (aggregators = this.getAggregators(EventSource.SHENANDOAH, registeredAggregations)) != null && !aggregators.isEmpty()) {
            aggregatorVerticle = new AggregatorVerticle("ShenandoahParser");
            aggregators.forEach(aggregatorVerticle::registerAggregator);
            aggregatorVerticles.add(aggregatorVerticle);
        }
        if (diary.isZGC() && (aggregators = this.getAggregators(EventSource.ZGC, registeredAggregations)) != null && !aggregators.isEmpty()) {
            aggregatorVerticle = new AggregatorVerticle("ZGCParser");
            aggregators.forEach(aggregatorVerticle::registerAggregator);
            aggregatorVerticles.add(aggregatorVerticle);
        }
        if (diary.isTenuringDistribution() && (aggregators = this.getAggregators(EventSource.SURVIVOR, registeredAggregations)) != null && !aggregators.isEmpty()) {
            aggregatorVerticle = new AggregatorVerticle("SurvivorMemoryPoolParser");
            aggregators.forEach(aggregatorVerticle::registerAggregator);
            aggregatorVerticles.add(aggregatorVerticle);
        }
        return aggregatorVerticles;
    }

    private String initMailBox(Diary diary) {
        if (diary.isG1GC()) {
            return "G1GCParser";
        }
        if (diary.isZGC()) {
            return "ZGCParser";
        }
        if (diary.isShenandoah()) {
            return "ShenandoahParser";
        }
        return "GenerationalHeapParser";
    }
}

