/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.vertx.jvm;

import com.microsoft.gctoolkit.event.jvm.JVMEvent;
import com.microsoft.gctoolkit.parser.GCLogParser;
import com.microsoft.gctoolkit.parser.JVMEventConsumer;
import com.microsoft.gctoolkit.vertx.internal.util.concurrent.StartingGun;
import com.microsoft.gctoolkit.vertx.jvm.ParserFactory;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.eventbus.DeliveryOptions;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogFileParser
extends AbstractVerticle
implements JVMEventConsumer {
    protected static final Logger LOGGER = Logger.getLogger(LogFileParser.class.getName());
    private final GCLogParser parser;
    private final String inbox;
    private final String outbox;
    private final DeliveryOptions options = new DeliveryOptions().setCodecName("JVMEvent");
    private final StartingGun deployed = new StartingGun();

    public LogFileParser(String inbox, String outbox, ParserFactory factory) {
        this.inbox = inbox;
        this.outbox = outbox;
        this.parser = factory.get(this);
    }

    public String getInbox() {
        return this.inbox;
    }

    public String getOutbox() {
        return this.outbox;
    }

    public void record(JVMEvent event) {
        try {
            if (event != null && event.getDateTimeStamp() != null) {
                this.vertx.eventBus().publish(this.outbox, (Object)event, this.options);
            } else {
                LOGGER.log(Level.SEVERE, "Thread: {0} is recording Event: {1} that has a null DateTimeStamp, it will be ignored", new Object[]{Thread.currentThread().getName(), event.toString()});
            }
        }
        catch (Error t) {
            LOGGER.throwing(((Object)((Object)this)).getClass().toString(), "record", t);
        }
    }

    public void awaitDeployment() {
        this.deployed.awaitUninterruptibly();
    }

    public void start() {
        this.vertx.eventBus().consumer(this.inbox, message -> {
            try {
                String body = ((String)message.body()).trim();
                if (body.isEmpty()) {
                    return;
                }
                this.parser.receive(body);
            }
            catch (Throwable t) {
                LOGGER.throwing(((Object)((Object)this)).getClass().getName(), "start", t);
            }
        });
        this.deployed.ready();
    }
}

