/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.vertx.jvm;

import com.microsoft.gctoolkit.aggregator.Aggregation;
import com.microsoft.gctoolkit.aggregator.Collates;
import com.microsoft.gctoolkit.time.DateTimeStamp;
import com.microsoft.gctoolkit.vertx.jvm.RuntimeDurationAggregator;

@Collates(value=RuntimeDurationAggregator.class)
class RuntimeDuration
implements Aggregation {
    private volatile DateTimeStamp timeOfFirstEvent = null;
    private volatile DateTimeStamp timeOfLastEvent = new DateTimeStamp(0.0);
    private static final double LOG_FRAGMENT_THRESHOLD = 18000.0;

    RuntimeDuration() {
    }

    public double getRuntimeDuration() {
        boolean isLogFragment = this.getTimeOfFirstEvent().getTimeStamp() > 18000.0;
        return isLogFragment ? this.getTimeOfLastEvent().minus(this.getTimeOfFirstEvent()) : this.getTimeOfLastEvent().getTimeStamp();
    }

    public DateTimeStamp getTimeOfFirstEvent() {
        return this.timeOfFirstEvent != null ? this.timeOfFirstEvent : new DateTimeStamp(0.0);
    }

    public DateTimeStamp getTimeOfLastEvent() {
        if (this.getTimeOfFirstEvent().before(this.timeOfLastEvent)) {
            return this.timeOfLastEvent;
        }
        return this.getTimeOfFirstEvent();
    }

    public boolean hasWarning() {
        return false;
    }

    public boolean isEmpty() {
        return false;
    }

    public void record(DateTimeStamp eventTime, double eventDuration) {
        DateTimeStamp now = eventTime.add(eventDuration);
        if (this.timeOfFirstEvent == null) {
            this.timeOfFirstEvent = now;
        }
        if (now.after(this.timeOfLastEvent)) {
            this.timeOfLastEvent = now;
        }
    }
}

