/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.vertx;

import com.microsoft.gctoolkit.event.jvm.JVMEvent;
import com.microsoft.gctoolkit.event.jvm.JVMTermination;
import com.microsoft.gctoolkit.message.JVMEventChannelListener;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JVMEventVerticle
extends AbstractVerticle {
    private static final Logger LOGGER = Logger.getLogger(JVMEventVerticle.class.getName());
    private final Vertx vertx;
    private final String inbox;
    private final JVMEventChannelListener processor;
    private String id;

    public JVMEventVerticle(Vertx vertx, String channelName, JVMEventChannelListener listener) {
        this.vertx = vertx;
        this.inbox = channelName;
        this.processor = listener;
    }

    public void setID(String id) {
        this.id = id;
    }

    public void start(Promise<Void> promise) {
        this.vertx.eventBus().consumer(this.inbox, message -> {
            JVMEvent event = (JVMEvent)message.body();
            try {
                this.processor.receive((Object)event);
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, "Vertx: processing JVMEvent failed", t);
            }
            if (event instanceof JVMTermination) {
                this.vertx.undeploy(this.id);
            }
        }).completionHandler(result -> promise.complete());
    }

    public void stop(Promise promise) {
        promise.complete();
    }

    public boolean equals(Object other) {
        return this == other;
    }

    public int hashCode() {
        return System.identityHashCode((Object)this);
    }
}

