/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.vertx;

import com.microsoft.gctoolkit.message.DataSourceChannelListener;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataSourceVerticle
extends AbstractVerticle {
    private static final Logger LOGGER = Logger.getLogger(DataSourceVerticle.class.getName());
    private final Vertx vertx;
    private final String inbox;
    private String id;
    private final DataSourceChannelListener processor;

    public DataSourceVerticle(Vertx vertx, String channelName, DataSourceChannelListener listener) {
        this.vertx = vertx;
        this.inbox = channelName;
        this.processor = listener;
    }

    public void setID(String id) {
        this.id = id;
    }

    public void start(Promise<Void> promise) {
        try {
            this.vertx.eventBus().consumer(this.inbox, message -> {
                this.processor.receive((Object)((String)message.body()));
                if ("END_OF_DATA_SENTINEL".equals(message.body())) {
                    this.vertx.undeploy(this.id);
                }
            }).completionHandler(result -> promise.complete());
        }
        catch (Throwable t) {
            LOGGER.log(Level.WARNING, "Vertx: processing DataSource failed", t);
        }
    }

    public boolean equals(Object other) {
        return this == other;
    }

    public int hashCode() {
        return System.identityHashCode((Object)this);
    }
}

