package com.microsoft.graph.beta.models;

import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
@jakarta.annotation.Generated("com.microsoft.kiota")
public class SubstringTransformation extends CustomClaimTransformation implements Parsable {
    /**
     * Instantiates a new {@link SubstringTransformation} and sets the default values.
     */
    public SubstringTransformation() {
        super();
        this.setOdataType("#microsoft.graph.substringTransformation");
    }
    /**
     * Creates a new instance of the appropriate class based on discriminator value
     * @param parseNode The parse node to use to read the discriminator value and create the object
     * @return a {@link SubstringTransformation}
     */
    @jakarta.annotation.Nonnull
    public static SubstringTransformation createFromDiscriminatorValue(@jakarta.annotation.Nonnull final ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new SubstringTransformation();
    }
    /**
     * The deserialization information for the current model
     * @return a {@link Map<String, java.util.function.Consumer<ParseNode>>}
     */
    @jakarta.annotation.Nonnull
    public Map<String, java.util.function.Consumer<ParseNode>> getFieldDeserializers() {
        final HashMap<String, java.util.function.Consumer<ParseNode>> deserializerMap = new HashMap<String, java.util.function.Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("index", (n) -> { this.setIndex(n.getIntegerValue()); });
        deserializerMap.put("length", (n) -> { this.setLength(n.getIntegerValue()); });
        return deserializerMap;
    }
    /**
     * Gets the index property value. The start index of the substring operation, where 0 is the first character in the string.
     * @return a {@link Integer}
     */
    @jakarta.annotation.Nullable
    public Integer getIndex() {
        return this.backingStore.get("index");
    }
    /**
     * Gets the length property value. The maximum length of the string, starting from the provided index.
     * @return a {@link Integer}
     */
    @jakarta.annotation.Nullable
    public Integer getLength() {
        return this.backingStore.get("length");
    }
    /**
     * Serializes information the current object
     * @param writer Serialization writer to use to serialize this model
     */
    public void serialize(@jakarta.annotation.Nonnull final SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeIntegerValue("index", this.getIndex());
        writer.writeIntegerValue("length", this.getLength());
    }
    /**
     * Sets the index property value. The start index of the substring operation, where 0 is the first character in the string.
     * @param value Value to set for the index property.
     */
    public void setIndex(@jakarta.annotation.Nullable final Integer value) {
        this.backingStore.set("index", value);
    }
    /**
     * Sets the length property value. The maximum length of the string, starting from the provided index.
     * @param value Value to set for the length property.
     */
    public void setLength(@jakarta.annotation.Nullable final Integer value) {
        this.backingStore.set("length", value);
    }
}
