/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.Conversation;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ConversationCollectionPage;
import com.microsoft.graph.requests.extensions.ConversationCollectionRequest;
import com.microsoft.graph.requests.extensions.ConversationCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ConversationRequestBuilder;
import com.microsoft.graph.requests.extensions.IConversationCollectionPage;
import com.microsoft.graph.requests.extensions.IConversationCollectionRequest;
import com.microsoft.graph.requests.generated.BaseConversationCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseConversationCollectionRequest;
import java.util.List;

public class BaseConversationCollectionRequest
extends BaseCollectionRequest<BaseConversationCollectionResponse, IConversationCollectionPage>
implements IBaseConversationCollectionRequest {
    public BaseConversationCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseConversationCollectionResponse.class, IConversationCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IConversationCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseConversationCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IConversationCollectionPage get() throws ClientException {
        BaseConversationCollectionResponse response = (BaseConversationCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(Conversation newConversation, ICallback<Conversation> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ConversationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newConversation, callback);
    }

    @Override
    public Conversation post(Conversation newConversation) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ConversationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newConversation);
    }

    @Override
    public IConversationCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (ConversationCollectionRequest)this;
    }

    @Override
    public IConversationCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (ConversationCollectionRequest)this;
    }

    @Override
    public IConversationCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (ConversationCollectionRequest)this;
    }

    public IConversationCollectionPage buildFromResponse(BaseConversationCollectionResponse response) {
        ConversationCollectionRequestBuilder builder = response.nextLink != null ? new ConversationCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ConversationCollectionPage page = new ConversationCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

