/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.DeviceCompliancePolicyState;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.DeviceCompliancePolicyStateCollectionPage;
import com.microsoft.graph.requests.extensions.DeviceCompliancePolicyStateCollectionRequest;
import com.microsoft.graph.requests.extensions.DeviceCompliancePolicyStateCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DeviceCompliancePolicyStateRequestBuilder;
import com.microsoft.graph.requests.extensions.IDeviceCompliancePolicyStateCollectionPage;
import com.microsoft.graph.requests.extensions.IDeviceCompliancePolicyStateCollectionRequest;
import com.microsoft.graph.requests.generated.BaseDeviceCompliancePolicyStateCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseDeviceCompliancePolicyStateCollectionRequest;
import java.util.List;

public class BaseDeviceCompliancePolicyStateCollectionRequest
extends BaseCollectionRequest<BaseDeviceCompliancePolicyStateCollectionResponse, IDeviceCompliancePolicyStateCollectionPage>
implements IBaseDeviceCompliancePolicyStateCollectionRequest {
    public BaseDeviceCompliancePolicyStateCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseDeviceCompliancePolicyStateCollectionResponse.class, IDeviceCompliancePolicyStateCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IDeviceCompliancePolicyStateCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseDeviceCompliancePolicyStateCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDeviceCompliancePolicyStateCollectionPage get() throws ClientException {
        BaseDeviceCompliancePolicyStateCollectionResponse response = (BaseDeviceCompliancePolicyStateCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(DeviceCompliancePolicyState newDeviceCompliancePolicyState, ICallback<DeviceCompliancePolicyState> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new DeviceCompliancePolicyStateRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDeviceCompliancePolicyState, callback);
    }

    @Override
    public DeviceCompliancePolicyState post(DeviceCompliancePolicyState newDeviceCompliancePolicyState) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DeviceCompliancePolicyStateRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDeviceCompliancePolicyState);
    }

    @Override
    public IDeviceCompliancePolicyStateCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (DeviceCompliancePolicyStateCollectionRequest)this;
    }

    @Override
    public IDeviceCompliancePolicyStateCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (DeviceCompliancePolicyStateCollectionRequest)this;
    }

    @Override
    public IDeviceCompliancePolicyStateCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (DeviceCompliancePolicyStateCollectionRequest)this;
    }

    public IDeviceCompliancePolicyStateCollectionPage buildFromResponse(BaseDeviceCompliancePolicyStateCollectionResponse response) {
        DeviceCompliancePolicyStateCollectionRequestBuilder builder = response.nextLink != null ? new DeviceCompliancePolicyStateCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DeviceCompliancePolicyStateCollectionPage page = new DeviceCompliancePolicyStateCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

