/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.DriveSearchCollectionPage;
import com.microsoft.graph.requests.extensions.DriveSearchCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IDriveSearchCollectionPage;
import com.microsoft.graph.requests.extensions.IDriveSearchCollectionRequest;
import com.microsoft.graph.requests.generated.BaseDriveSearchCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseDriveSearchCollectionRequest;
import java.util.List;

public class BaseDriveSearchCollectionRequest
extends BaseCollectionRequest<BaseDriveSearchCollectionResponse, IDriveSearchCollectionPage>
implements IBaseDriveSearchCollectionRequest {
    public BaseDriveSearchCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseDriveSearchCollectionResponse.class, IDriveSearchCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IDriveSearchCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseDriveSearchCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDriveSearchCollectionPage get() throws ClientException {
        BaseDriveSearchCollectionResponse response = (BaseDriveSearchCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    public IDriveSearchCollectionPage buildFromResponse(BaseDriveSearchCollectionResponse response) {
        DriveSearchCollectionRequestBuilder builder = response.nextLink != null ? new DriveSearchCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null, null) : null;
        DriveSearchCollectionPage page = new DriveSearchCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }

    @Override
    public IDriveSearchCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (IDriveSearchCollectionRequest)((Object)this);
    }

    @Override
    public IDriveSearchCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (IDriveSearchCollectionRequest)((Object)this);
    }

    @Override
    public IDriveSearchCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (IDriveSearchCollectionRequest)((Object)this);
    }
}

