/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.EducationSchoolCollectionWithReferencesPage;
import com.microsoft.graph.requests.extensions.EducationSchoolCollectionWithReferencesRequest;
import com.microsoft.graph.requests.extensions.EducationSchoolCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.extensions.IEducationSchoolCollectionPage;
import com.microsoft.graph.requests.extensions.IEducationSchoolCollectionWithReferencesPage;
import com.microsoft.graph.requests.extensions.IEducationSchoolCollectionWithReferencesRequest;
import com.microsoft.graph.requests.generated.BaseEducationSchoolCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseEducationSchoolCollectionWithReferencesRequest;
import java.util.List;

public class BaseEducationSchoolCollectionWithReferencesRequest
extends BaseCollectionRequest<BaseEducationSchoolCollectionResponse, IEducationSchoolCollectionPage>
implements IBaseEducationSchoolCollectionWithReferencesRequest {
    public BaseEducationSchoolCollectionWithReferencesRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseEducationSchoolCollectionResponse.class, IEducationSchoolCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IEducationSchoolCollectionWithReferencesPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseEducationSchoolCollectionWithReferencesRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IEducationSchoolCollectionWithReferencesPage get() throws ClientException {
        BaseEducationSchoolCollectionResponse response = (BaseEducationSchoolCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public IEducationSchoolCollectionWithReferencesRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (EducationSchoolCollectionWithReferencesRequest)this;
    }

    @Override
    public IEducationSchoolCollectionWithReferencesRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (EducationSchoolCollectionWithReferencesRequest)this;
    }

    @Override
    public IEducationSchoolCollectionWithReferencesRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (EducationSchoolCollectionWithReferencesRequest)this;
    }

    public IEducationSchoolCollectionWithReferencesPage buildFromResponse(BaseEducationSchoolCollectionResponse response) {
        EducationSchoolCollectionWithReferencesRequestBuilder builder = response.nextLink != null ? new EducationSchoolCollectionWithReferencesRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        EducationSchoolCollectionWithReferencesPage page = new EducationSchoolCollectionWithReferencesPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

