/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.OnenoteResource;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IOnenoteResourceCollectionPage;
import com.microsoft.graph.requests.extensions.IOnenoteResourceCollectionRequest;
import com.microsoft.graph.requests.extensions.OnenoteResourceCollectionPage;
import com.microsoft.graph.requests.extensions.OnenoteResourceCollectionRequest;
import com.microsoft.graph.requests.extensions.OnenoteResourceCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.OnenoteResourceRequestBuilder;
import com.microsoft.graph.requests.generated.BaseOnenoteResourceCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseOnenoteResourceCollectionRequest;
import java.util.List;

public class BaseOnenoteResourceCollectionRequest
extends BaseCollectionRequest<BaseOnenoteResourceCollectionResponse, IOnenoteResourceCollectionPage>
implements IBaseOnenoteResourceCollectionRequest {
    public BaseOnenoteResourceCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseOnenoteResourceCollectionResponse.class, IOnenoteResourceCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IOnenoteResourceCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseOnenoteResourceCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IOnenoteResourceCollectionPage get() throws ClientException {
        BaseOnenoteResourceCollectionResponse response = (BaseOnenoteResourceCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(OnenoteResource newOnenoteResource, ICallback<OnenoteResource> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new OnenoteResourceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newOnenoteResource, callback);
    }

    @Override
    public OnenoteResource post(OnenoteResource newOnenoteResource) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new OnenoteResourceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newOnenoteResource);
    }

    @Override
    public IOnenoteResourceCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (OnenoteResourceCollectionRequest)this;
    }

    @Override
    public IOnenoteResourceCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (OnenoteResourceCollectionRequest)this;
    }

    @Override
    public IOnenoteResourceCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (OnenoteResourceCollectionRequest)this;
    }

    public IOnenoteResourceCollectionPage buildFromResponse(BaseOnenoteResourceCollectionResponse response) {
        OnenoteResourceCollectionRequestBuilder builder = response.nextLink != null ? new OnenoteResourceCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        OnenoteResourceCollectionPage page = new OnenoteResourceCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

