/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.PlannerPlan;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IPlannerPlanCollectionPage;
import com.microsoft.graph.requests.extensions.IPlannerPlanCollectionRequest;
import com.microsoft.graph.requests.extensions.PlannerPlanCollectionPage;
import com.microsoft.graph.requests.extensions.PlannerPlanCollectionRequest;
import com.microsoft.graph.requests.extensions.PlannerPlanCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.PlannerPlanRequestBuilder;
import com.microsoft.graph.requests.generated.BasePlannerPlanCollectionResponse;
import com.microsoft.graph.requests.generated.IBasePlannerPlanCollectionRequest;
import java.util.List;

public class BasePlannerPlanCollectionRequest
extends BaseCollectionRequest<BasePlannerPlanCollectionResponse, IPlannerPlanCollectionPage>
implements IBasePlannerPlanCollectionRequest {
    public BasePlannerPlanCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BasePlannerPlanCollectionResponse.class, IPlannerPlanCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IPlannerPlanCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BasePlannerPlanCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IPlannerPlanCollectionPage get() throws ClientException {
        BasePlannerPlanCollectionResponse response = (BasePlannerPlanCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(PlannerPlan newPlannerPlan, ICallback<PlannerPlan> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new PlannerPlanRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newPlannerPlan, callback);
    }

    @Override
    public PlannerPlan post(PlannerPlan newPlannerPlan) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new PlannerPlanRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newPlannerPlan);
    }

    @Override
    public IPlannerPlanCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (PlannerPlanCollectionRequest)this;
    }

    @Override
    public IPlannerPlanCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (PlannerPlanCollectionRequest)this;
    }

    @Override
    public IPlannerPlanCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (PlannerPlanCollectionRequest)this;
    }

    public IPlannerPlanCollectionPage buildFromResponse(BasePlannerPlanCollectionResponse response) {
        PlannerPlanCollectionRequestBuilder builder = response.nextLink != null ? new PlannerPlanCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        PlannerPlanCollectionPage page = new PlannerPlanCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

