/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.TermsAndConditions;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ITermsAndConditionsCollectionPage;
import com.microsoft.graph.requests.extensions.ITermsAndConditionsCollectionRequest;
import com.microsoft.graph.requests.extensions.TermsAndConditionsCollectionPage;
import com.microsoft.graph.requests.extensions.TermsAndConditionsCollectionRequest;
import com.microsoft.graph.requests.extensions.TermsAndConditionsCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.TermsAndConditionsRequestBuilder;
import com.microsoft.graph.requests.generated.BaseTermsAndConditionsCollectionResponse;
import com.microsoft.graph.requests.generated.IBaseTermsAndConditionsCollectionRequest;
import java.util.List;

public class BaseTermsAndConditionsCollectionRequest
extends BaseCollectionRequest<BaseTermsAndConditionsCollectionResponse, ITermsAndConditionsCollectionPage>
implements IBaseTermsAndConditionsCollectionRequest {
    public BaseTermsAndConditionsCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseTermsAndConditionsCollectionResponse.class, ITermsAndConditionsCollectionPage.class);
    }

    @Override
    public void get(final ICallback<ITermsAndConditionsCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseTermsAndConditionsCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ITermsAndConditionsCollectionPage get() throws ClientException {
        BaseTermsAndConditionsCollectionResponse response = (BaseTermsAndConditionsCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(TermsAndConditions newTermsAndConditions, ICallback<TermsAndConditions> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new TermsAndConditionsRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newTermsAndConditions, callback);
    }

    @Override
    public TermsAndConditions post(TermsAndConditions newTermsAndConditions) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new TermsAndConditionsRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newTermsAndConditions);
    }

    @Override
    public ITermsAndConditionsCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (TermsAndConditionsCollectionRequest)this;
    }

    @Override
    public ITermsAndConditionsCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (TermsAndConditionsCollectionRequest)this;
    }

    @Override
    public ITermsAndConditionsCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (TermsAndConditionsCollectionRequest)this;
    }

    public ITermsAndConditionsCollectionPage buildFromResponse(BaseTermsAndConditionsCollectionResponse response) {
        TermsAndConditionsCollectionRequestBuilder builder = response.nextLink != null ? new TermsAndConditionsCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        TermsAndConditionsCollectionPage page = new TermsAndConditionsCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

