/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.serializer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapterFactory;
import com.microsoft.graph.logger.ILogger;
import com.microsoft.graph.models.extensions.DateOnly;
import com.microsoft.graph.serializer.ByteArraySerializer;
import com.microsoft.graph.serializer.CalendarSerializer;
import com.microsoft.graph.serializer.EnumSetSerializer;
import com.microsoft.graph.serializer.FallbackTypeAdapterFactory;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.util.Calendar;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;

final class GsonFactory {
    private static String PARSING_MESSAGE = "Parsing issue on ";

    private GsonFactory() {
    }

    public static Gson getGsonInstance(final ILogger logger) {
        JsonSerializer<Calendar> calendarJsonSerializer = new JsonSerializer<Calendar>(){

            public JsonElement serialize(Calendar src, Type typeOfSrc, JsonSerializationContext context) {
                if (src == null) {
                    return null;
                }
                try {
                    return new JsonPrimitive(CalendarSerializer.serialize(src));
                }
                catch (Exception e) {
                    logger.logError(PARSING_MESSAGE + src, e);
                    return null;
                }
            }
        };
        JsonDeserializer<Calendar> calendarJsonDeserializer = new JsonDeserializer<Calendar>(){

            public Calendar deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                if (json == null) {
                    return null;
                }
                try {
                    return CalendarSerializer.deserialize(json.getAsString());
                }
                catch (ParseException e) {
                    logger.logError(PARSING_MESSAGE + json.getAsString(), e);
                    return null;
                }
            }
        };
        JsonSerializer<byte[]> byteArrayJsonSerializer = new JsonSerializer<byte[]>(){

            public JsonElement serialize(byte[] src, Type typeOfSrc, JsonSerializationContext context) {
                if (src == null) {
                    return null;
                }
                try {
                    return new JsonPrimitive(ByteArraySerializer.serialize(src));
                }
                catch (Exception e) {
                    logger.logError(PARSING_MESSAGE + src, e);
                    return null;
                }
            }
        };
        JsonDeserializer<byte[]> byteArrayJsonDeserializer = new JsonDeserializer<byte[]>(){

            public byte[] deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                if (json == null) {
                    return null;
                }
                try {
                    return ByteArraySerializer.deserialize(json.getAsString());
                }
                catch (ParseException e) {
                    logger.logError(PARSING_MESSAGE + json.getAsString(), e);
                    return null;
                }
            }
        };
        JsonSerializer<DateOnly> dateJsonSerializer = new JsonSerializer<DateOnly>(){

            public JsonElement serialize(DateOnly src, Type typeOfSrc, JsonSerializationContext context) {
                if (src == null) {
                    return null;
                }
                return new JsonPrimitive(src.toString());
            }
        };
        JsonDeserializer<DateOnly> dateJsonDeserializer = new JsonDeserializer<DateOnly>(){

            public DateOnly deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                if (json == null) {
                    return null;
                }
                try {
                    return DateOnly.parse(json.getAsString());
                }
                catch (ParseException e) {
                    logger.logError(PARSING_MESSAGE + json.getAsString(), e);
                    return null;
                }
            }
        };
        JsonSerializer enumSetJsonSerializer = new JsonSerializer<EnumSet<?>>(){

            public JsonElement serialize(EnumSet<?> src, Type typeOfSrc, JsonSerializationContext context) {
                if (src == null || src.isEmpty()) {
                    return null;
                }
                return EnumSetSerializer.serialize(src);
            }
        };
        JsonDeserializer enumSetJsonDeserializer = new JsonDeserializer<EnumSet<?>>(){

            public EnumSet<?> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                if (json == null) {
                    return null;
                }
                return EnumSetSerializer.deserialize(typeOfT, json.getAsString());
            }
        };
        JsonSerializer<Duration> durationJsonSerializer = new JsonSerializer<Duration>(){

            public JsonElement serialize(Duration src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(src.toString());
            }
        };
        JsonDeserializer<Duration> durationJsonDeserializer = new JsonDeserializer<Duration>(){

            public Duration deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                try {
                    return DatatypeFactory.newInstance().newDuration(json.toString());
                }
                catch (Exception e) {
                    return null;
                }
            }
        };
        return new GsonBuilder().excludeFieldsWithoutExposeAnnotation().registerTypeAdapter(Calendar.class, (Object)calendarJsonSerializer).registerTypeAdapter(Calendar.class, (Object)calendarJsonDeserializer).registerTypeAdapter(GregorianCalendar.class, (Object)calendarJsonSerializer).registerTypeAdapter(GregorianCalendar.class, (Object)calendarJsonDeserializer).registerTypeAdapter(byte[].class, (Object)byteArrayJsonDeserializer).registerTypeAdapter(byte[].class, (Object)byteArrayJsonSerializer).registerTypeAdapter(DateOnly.class, (Object)dateJsonSerializer).registerTypeAdapter(DateOnly.class, (Object)dateJsonDeserializer).registerTypeAdapter(EnumSet.class, (Object)enumSetJsonSerializer).registerTypeAdapter(EnumSet.class, (Object)enumSetJsonDeserializer).registerTypeAdapter(Duration.class, (Object)durationJsonSerializer).registerTypeAdapter(Duration.class, (Object)durationJsonDeserializer).registerTypeAdapterFactory((TypeAdapterFactory)new FallbackTypeAdapterFactory(logger)).create();
    }
}

