/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.http;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.CustomRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.http.IHttpRequest;
import com.microsoft.graph.options.FunctionOption;
import com.microsoft.graph.options.HeaderOption;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.core.UriBuilder;

public abstract class BaseRequest
implements IHttpRequest {
    private static final String REQUEST_STATS_HEADER_NAME = "SdkVersion";
    public static final String REQUEST_STATS_HEADER_VALUE_FORMAT_STRING = "graph-java-v%s";
    private HttpMethod method;
    private final String requestUrl;
    private final IBaseClient client;
    private final List<HeaderOption> headersOptions;
    protected final List<QueryOption> queryOptions;
    protected final List<FunctionOption> functionOptions;
    private final Class<?> responseClass;
    private boolean useCaches;

    public BaseRequest(String requestUrl, IBaseClient client, List<? extends Option> options, Class<?> responseClass) {
        this.requestUrl = requestUrl;
        this.client = client;
        this.responseClass = responseClass;
        this.headersOptions = new ArrayList<HeaderOption>();
        this.queryOptions = new ArrayList<QueryOption>();
        this.functionOptions = new ArrayList<FunctionOption>();
        if (options != null) {
            for (Option option : options) {
                if (option instanceof HeaderOption) {
                    this.headersOptions.add((HeaderOption)option);
                }
                if (option instanceof QueryOption) {
                    this.queryOptions.add((QueryOption)option);
                }
                if (!(option instanceof FunctionOption)) continue;
                this.functionOptions.add((FunctionOption)option);
            }
        }
        HeaderOption requestStatsHeader = new HeaderOption(REQUEST_STATS_HEADER_NAME, String.format(REQUEST_STATS_HEADER_VALUE_FORMAT_STRING, "1.1.0"));
        this.headersOptions.add(requestStatsHeader);
    }

    @Override
    public URL getRequestUrl() {
        String requestUrl = this.addFunctionParameters();
        URI baseUrl = URI.create(requestUrl);
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)baseUrl);
        for (QueryOption option : this.queryOptions) {
            uriBuilder.queryParam(option.getName(), new Object[]{option.getValue().toString()});
        }
        try {
            return new URL(uriBuilder.build(new Object[0]).toString());
        }
        catch (MalformedURLException e) {
            if (!(this instanceof CustomRequest)) {
                throw new ClientException("Invalid URL: " + uriBuilder.toString(), e);
            }
            this.getClient().getLogger().logError("Invalid custom URL: " + uriBuilder.toString(), e);
            return null;
        }
    }

    private String addFunctionParameters() {
        StringBuilder requestUrl = new StringBuilder(this.requestUrl);
        if (!this.getFunctionOptions().isEmpty()) {
            requestUrl.append("(");
            for (int i = 0; i < this.functionOptions.size(); ++i) {
                FunctionOption option = this.functionOptions.get(i);
                requestUrl.append(option.getName());
                requestUrl.append("=");
                if (option.getValue() != null) {
                    if (option.getValue() instanceof String) {
                        requestUrl.append("'" + option.getValue() + "'");
                    } else {
                        requestUrl.append(option.getValue());
                    }
                } else {
                    requestUrl.append("null");
                }
                if (i + 1 >= this.functionOptions.size()) continue;
                requestUrl.append(",");
            }
            requestUrl.append(")");
        }
        return requestUrl.toString();
    }

    @Override
    public HttpMethod getHttpMethod() {
        return this.method;
    }

    @Override
    public List<HeaderOption> getHeaders() {
        return this.headersOptions;
    }

    @Override
    public void addHeader(String header, String value) {
        this.headersOptions.add(new HeaderOption(header, value));
    }

    @Override
    public void setUseCaches(boolean useCaches) {
        this.useCaches = useCaches;
    }

    @Override
    public boolean getUseCaches() {
        return this.useCaches;
    }

    protected <T1, T2> void send(HttpMethod method, ICallback<T1> callback, T2 serializedObject) {
        this.method = method;
        this.client.getHttpProvider().send((IHttpRequest)this, callback, this.responseClass, serializedObject);
    }

    protected <T1, T2> T1 send(HttpMethod method, T2 serializedObject) throws ClientException {
        this.method = method;
        return (T1)this.client.getHttpProvider().send(this, this.responseClass, serializedObject);
    }

    public List<QueryOption> getQueryOptions() {
        return this.queryOptions;
    }

    public List<FunctionOption> getFunctionOptions() {
        return this.functionOptions;
    }

    @Override
    public List<Option> getOptions() {
        LinkedList<Option> list = new LinkedList<Option>();
        list.addAll(this.headersOptions);
        list.addAll(this.queryOptions);
        list.addAll(this.functionOptions);
        return Collections.unmodifiableList(list);
    }

    public void addQueryOption(QueryOption option) {
        this.getQueryOptions().add(option);
    }

    public void addFunctionOption(FunctionOption option) {
        this.getFunctionOptions().add(option);
    }

    public void setHttpMethod(HttpMethod httpMethod) {
        this.method = httpMethod;
    }

    public IBaseClient getClient() {
        return this.client;
    }

    public Class<?> getResponseType() {
        return this.responseClass;
    }
}

