// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Entity With Reference Request.
 */
public class EntityWithReferenceRequest extends BaseRequest implements IEntityWithReferenceRequest {

    /**
     * The request for the Entity
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public EntityWithReferenceRequest(String requestUrl, IBaseClient client, java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Entity.class);
    }

    public void post(final Entity newEntity, final IJsonBackedObject payload, final ICallback<Entity> callback) {
        send(HttpMethod.POST, callback, payload);
    }

    public Entity post(final Entity newEntity, final IJsonBackedObject payload) throws ClientException {
        IJsonBackedObject response = send(HttpMethod.POST, payload);
        if (response != null){
            return newEntity;
        }
        return null;
    }

    public void get(final ICallback<Entity> callback) {
        send(HttpMethod.GET, callback, null);
    }

    public Entity get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

	public void delete(final ICallback<Entity> callback) {
		send(HttpMethod.DELETE, callback, null);
	}

	public void delete() throws ClientException {
		send(HttpMethod.DELETE, null);
	}

	public void patch(final Entity sourceEntity, final ICallback<Entity> callback) {
		send(HttpMethod.PATCH, callback, sourceEntity);
	}

	public Entity patch(final Entity sourceEntity) throws ClientException {
		return send(HttpMethod.PATCH, sourceEntity);
	}


    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public IEntityWithReferenceRequest select(final String value) {
        getQueryOptions().add(new QueryOption("$select", value));
        return (IEntityWithReferenceRequest)this;
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public IEntityWithReferenceRequest expand(final String value) {
        getQueryOptions().add(new QueryOption("$expand", value));
        return (EntityWithReferenceRequest)this;
    }
}
