// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Event Collection Request.
 */
public class EventCollectionRequest extends BaseCollectionRequest<EventCollectionResponse, IEventCollectionPage> implements IEventCollectionRequest {

    /**
     * The request builder for this collection of Event
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public EventCollectionRequest(final String requestUrl, IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, EventCollectionResponse.class, IEventCollectionPage.class);
    }

    public void get(final ICallback<IEventCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public IEventCollectionPage get() throws ClientException {
        final EventCollectionResponse response = send();
        return buildFromResponse(response);
    }

    public void post(final Event newEvent, final ICallback<Event> callback) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        new EventRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newEvent, callback);
    }

    public Event post(final Event newEvent) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new EventRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newEvent);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public IEventCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("$expand", value));
        return (EventCollectionRequest)this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public IEventCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("$select", value));
        return (EventCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value the max number of items to return
     * @return the updated request
     */
    public IEventCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("$top", value + ""));
        return (EventCollectionRequest)this;
    }

    public IEventCollectionPage buildFromResponse(final EventCollectionResponse response) {
        final IEventCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new EventCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final EventCollectionPage page = new EventCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
