// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IGroupLifecyclePolicyRequest;
import com.microsoft.graph.requests.extensions.GroupLifecyclePolicyRequest;
import com.microsoft.graph.requests.extensions.IGroupLifecyclePolicyAddGroupRequestBuilder;
import com.microsoft.graph.requests.extensions.GroupLifecyclePolicyAddGroupRequestBuilder;
import com.microsoft.graph.requests.extensions.IGroupLifecyclePolicyRemoveGroupRequestBuilder;
import com.microsoft.graph.requests.extensions.GroupLifecyclePolicyRemoveGroupRequestBuilder;

import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.options.Option;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Group Lifecycle Policy Request Builder.
 */
public class GroupLifecyclePolicyRequestBuilder extends BaseRequestBuilder implements IGroupLifecyclePolicyRequestBuilder {

    /**
     * The request builder for the GroupLifecyclePolicy
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public GroupLifecyclePolicyRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @return the IGroupLifecyclePolicyRequest instance
     */
    public IGroupLifecyclePolicyRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the IGroupLifecyclePolicyRequest instance
     */
    public IGroupLifecyclePolicyRequest buildRequest(final java.util.List<? extends Option> requestOptions) {
        return new GroupLifecyclePolicyRequest(getRequestUrl(), getClient(), requestOptions);
    }



    public IGroupLifecyclePolicyAddGroupRequestBuilder addGroup(final String groupId) {
        return new GroupLifecyclePolicyAddGroupRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.addGroup"), getClient(), null, groupId);
    }

    public IGroupLifecyclePolicyRemoveGroupRequestBuilder removeGroup(final String groupId) {
        return new GroupLifecyclePolicyRemoveGroupRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.removeGroup"), getClient(), null, groupId);
    }
}

