// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.AndroidManagedAppProtection;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Android Managed App Protection Request.
 */
public interface IAndroidManagedAppProtectionRequest extends IHttpRequest {

    /**
     * Gets the AndroidManagedAppProtection from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<AndroidManagedAppProtection> callback);

    /**
     * Gets the AndroidManagedAppProtection from the service
     *
     * @return the AndroidManagedAppProtection from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    AndroidManagedAppProtection get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<AndroidManagedAppProtection> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this AndroidManagedAppProtection with a source
     *
     * @param sourceAndroidManagedAppProtection the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final AndroidManagedAppProtection sourceAndroidManagedAppProtection, final ICallback<AndroidManagedAppProtection> callback);

    /**
     * Patches this AndroidManagedAppProtection with a source
     *
     * @param sourceAndroidManagedAppProtection the source object with updates
     * @return the updated AndroidManagedAppProtection
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    AndroidManagedAppProtection patch(final AndroidManagedAppProtection sourceAndroidManagedAppProtection) throws ClientException;

    /**
     * Posts a AndroidManagedAppProtection with a new object
     *
     * @param newAndroidManagedAppProtection the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final AndroidManagedAppProtection newAndroidManagedAppProtection, final ICallback<AndroidManagedAppProtection> callback);

    /**
     * Posts a AndroidManagedAppProtection with a new object
     *
     * @param newAndroidManagedAppProtection the new object to create
     * @return the created AndroidManagedAppProtection
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    AndroidManagedAppProtection post(final AndroidManagedAppProtection newAndroidManagedAppProtection) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IAndroidManagedAppProtectionRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IAndroidManagedAppProtectionRequest expand(final String value);

}

