// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Setting State Device Summary Collection Request.
 */
public class SettingStateDeviceSummaryCollectionRequest extends BaseCollectionRequest<SettingStateDeviceSummaryCollectionResponse, ISettingStateDeviceSummaryCollectionPage> implements ISettingStateDeviceSummaryCollectionRequest {

    /**
     * The request builder for this collection of SettingStateDeviceSummary
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public SettingStateDeviceSummaryCollectionRequest(final String requestUrl, IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, SettingStateDeviceSummaryCollectionResponse.class, ISettingStateDeviceSummaryCollectionPage.class);
    }

    public void get(final ICallback<ISettingStateDeviceSummaryCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public ISettingStateDeviceSummaryCollectionPage get() throws ClientException {
        final SettingStateDeviceSummaryCollectionResponse response = send();
        return buildFromResponse(response);
    }

    public void post(final SettingStateDeviceSummary newSettingStateDeviceSummary, final ICallback<SettingStateDeviceSummary> callback) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        new SettingStateDeviceSummaryRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newSettingStateDeviceSummary, callback);
    }

    public SettingStateDeviceSummary post(final SettingStateDeviceSummary newSettingStateDeviceSummary) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new SettingStateDeviceSummaryRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newSettingStateDeviceSummary);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public ISettingStateDeviceSummaryCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("$expand", value));
        return (SettingStateDeviceSummaryCollectionRequest)this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public ISettingStateDeviceSummaryCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("$select", value));
        return (SettingStateDeviceSummaryCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value the max number of items to return
     * @return the updated request
     */
    public ISettingStateDeviceSummaryCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("$top", value + ""));
        return (SettingStateDeviceSummaryCollectionRequest)this;
    }

    public ISettingStateDeviceSummaryCollectionPage buildFromResponse(final SettingStateDeviceSummaryCollectionResponse response) {
        final ISettingStateDeviceSummaryCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new SettingStateDeviceSummaryCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final SettingStateDeviceSummaryCollectionPage page = new SettingStateDeviceSummaryCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
