// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IGroupSettingTemplateRequest;
import com.microsoft.graph.requests.extensions.GroupSettingTemplateRequest;
import com.microsoft.graph.models.extensions.GroupSettingTemplate;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Group Setting Template Request.
 */
public class GroupSettingTemplateRequest extends BaseRequest implements IGroupSettingTemplateRequest {
	
    /**
     * The request for the GroupSettingTemplate
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public GroupSettingTemplateRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, GroupSettingTemplate.class);
    }

    /**
     * Gets the GroupSettingTemplate from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<GroupSettingTemplate> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the GroupSettingTemplate from the service
     *
     * @return the GroupSettingTemplate from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public GroupSettingTemplate get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<GroupSettingTemplate> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this GroupSettingTemplate with a source
     *
     * @param sourceGroupSettingTemplate the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final GroupSettingTemplate sourceGroupSettingTemplate, final ICallback<GroupSettingTemplate> callback) {
        send(HttpMethod.PATCH, callback, sourceGroupSettingTemplate);
    }

    /**
     * Patches this GroupSettingTemplate with a source
     *
     * @param sourceGroupSettingTemplate the source object with updates
     * @return the updated GroupSettingTemplate
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public GroupSettingTemplate patch(final GroupSettingTemplate sourceGroupSettingTemplate) throws ClientException {
        return send(HttpMethod.PATCH, sourceGroupSettingTemplate);
    }

    /**
     * Creates a GroupSettingTemplate with a new object
     *
     * @param newGroupSettingTemplate the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final GroupSettingTemplate newGroupSettingTemplate, final ICallback<GroupSettingTemplate> callback) {
        send(HttpMethod.POST, callback, newGroupSettingTemplate);
    }

    /**
     * Creates a GroupSettingTemplate with a new object
     *
     * @param newGroupSettingTemplate the new object to create
     * @return the created GroupSettingTemplate
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public GroupSettingTemplate post(final GroupSettingTemplate newGroupSettingTemplate) throws ClientException {
        return send(HttpMethod.POST, newGroupSettingTemplate);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public IGroupSettingTemplateRequest select(final String value) {
         getQueryOptions().add(new QueryOption("$select", value));
         return (GroupSettingTemplateRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public IGroupSettingTemplateRequest expand(final String value) {
         getQueryOptions().add(new QueryOption("$expand", value));
         return (GroupSettingTemplateRequest)this;
     }

}

