// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IWorkbookTableTotalRowRangeRequest;
import com.microsoft.graph.requests.extensions.WorkbookTableTotalRowRangeRequest;

import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.BaseFunctionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.FunctionOption;
import com.google.gson.JsonElement;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Table Total Row Range Request Builder.
 */
public class WorkbookTableTotalRowRangeRequestBuilder extends BaseFunctionRequestBuilder implements IWorkbookTableTotalRowRangeRequestBuilder {

    /**
     * The request builder for this WorkbookTableTotalRowRange
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WorkbookTableTotalRowRangeRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the IWorkbookTableTotalRowRangeRequest
     *
     * @return the IWorkbookTableTotalRowRangeRequest instance
     */
    public IWorkbookTableTotalRowRangeRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IWorkbookTableTotalRowRangeRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the IWorkbookTableTotalRowRangeRequest instance
     */
    public IWorkbookTableTotalRowRangeRequest buildRequest(final java.util.List<? extends Option> requestOptions) {
        WorkbookTableTotalRowRangeRequest request = new WorkbookTableTotalRowRangeRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

      for (FunctionOption option : functionOptions) {
            request.addFunctionOption(option);
      }

        return request;
    }
}
