// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;
import java.util.Arrays;
import java.util.EnumSet;


import com.google.gson.JsonObject;
import com.google.gson.JsonElement;
import com.google.gson.annotations.*;
import java.util.HashMap;
import java.util.Map;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Team Messaging Settings.
 */
public class TeamMessagingSettings implements IJsonBackedObject {

    @SerializedName("@odata.type")
    @Expose
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Allow User Edit Messages.
     * If set to true, users can edit their messages.
     */
    @SerializedName("allowUserEditMessages")
    @Expose
    public Boolean allowUserEditMessages;

    /**
     * The Allow User Delete Messages.
     * If set to true, users can delete their messages.
     */
    @SerializedName("allowUserDeleteMessages")
    @Expose
    public Boolean allowUserDeleteMessages;

    /**
     * The Allow Owner Delete Messages.
     * If set to true, owners can delete any message.
     */
    @SerializedName("allowOwnerDeleteMessages")
    @Expose
    public Boolean allowOwnerDeleteMessages;

    /**
     * The Allow Team Mentions.
     * If set to true, @team mentions are allowed.
     */
    @SerializedName("allowTeamMentions")
    @Expose
    public Boolean allowTeamMentions;

    /**
     * The Allow Channel Mentions.
     * If set to true, @channel mentions are allowed.
     */
    @SerializedName("allowChannelMentions")
    @Expose
    public Boolean allowChannelMentions;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;

    }
}
