// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.MessageRule;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Message Rule Request.
 */
public interface IMessageRuleRequest extends IHttpRequest {

    /**
     * Gets the MessageRule from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<MessageRule> callback);

    /**
     * Gets the MessageRule from the service
     *
     * @return the MessageRule from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    MessageRule get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<MessageRule> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this MessageRule with a source
     *
     * @param sourceMessageRule the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final MessageRule sourceMessageRule, final ICallback<MessageRule> callback);

    /**
     * Patches this MessageRule with a source
     *
     * @param sourceMessageRule the source object with updates
     * @return the updated MessageRule
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    MessageRule patch(final MessageRule sourceMessageRule) throws ClientException;

    /**
     * Posts a MessageRule with a new object
     *
     * @param newMessageRule the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final MessageRule newMessageRule, final ICallback<MessageRule> callback);

    /**
     * Posts a MessageRule with a new object
     *
     * @param newMessageRule the new object to create
     * @return the created MessageRule
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    MessageRule post(final MessageRule newMessageRule) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IMessageRuleRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IMessageRuleRequest expand(final String value);

}

