// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IWorkbookWorksheetRequest;
import com.microsoft.graph.requests.extensions.IWorkbookChartCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookChartRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookNamedItemCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookNamedItemRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookPivotTableCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookPivotTableRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookWorksheetProtectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookTableCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookTableRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookWorksheetCellRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookWorksheetRangeRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookWorksheetRangeRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookWorksheetUsedRangeRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookWorksheetUsedRangeRequestBuilder;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.options.Option;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Workbook Worksheet Request Builder.
 */
public interface IWorkbookWorksheetRequestBuilder extends IRequestBuilder {
    /**
     * Creates the request
     *
     * @return the IWorkbookWorksheetRequest instance
     */
    IWorkbookWorksheetRequest buildRequest();

    /**
     * Creates the request with specific options instead of the existing options
     *
     * @param requestOptions the options for this request
     * @return the IWorkbookWorksheetRequest instance
     */
    IWorkbookWorksheetRequest buildRequest(final java.util.List<? extends Option> requestOptions);


    IWorkbookChartCollectionRequestBuilder charts();

    IWorkbookChartRequestBuilder charts(final String id);

    IWorkbookNamedItemCollectionRequestBuilder names();

    IWorkbookNamedItemRequestBuilder names(final String id);

    IWorkbookPivotTableCollectionRequestBuilder pivotTables();

    IWorkbookPivotTableRequestBuilder pivotTables(final String id);

    /**
     * Gets the request builder for WorkbookWorksheetProtection
     *
     * @return the IWorkbookWorksheetProtectionRequestBuilder instance
     */
    IWorkbookWorksheetProtectionRequestBuilder protection();

    IWorkbookTableCollectionRequestBuilder tables();

    IWorkbookTableRequestBuilder tables(final String id);
    IWorkbookWorksheetCellRequestBuilder cell(final Integer row, final Integer column);
    IWorkbookWorksheetRangeRequestBuilder range();
    IWorkbookWorksheetRangeRequestBuilder range(final String address);
    IWorkbookWorksheetUsedRangeRequestBuilder usedRange();
    IWorkbookWorksheetUsedRangeRequestBuilder usedRange(final Boolean valuesOnly);

}
