// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the User Activity Reference Request.
 */
public class UserActivityReferenceRequest extends BaseRequest implements IUserActivityReferenceRequest {

    /**
     * The request for the UserActivity
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public UserActivityReferenceRequest(String requestUrl, IBaseClient client, java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, UserActivity.class);
    }

    public void delete(final ICallback<UserActivity> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    public UserActivity delete() throws ClientException {
       return send(HttpMethod.DELETE, null);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public IUserActivityReferenceRequest select(final String value) {
        getQueryOptions().add(new QueryOption("$select", value));
        return (UserActivityReferenceRequest)this;
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public IUserActivityReferenceRequest expand(final String value) {
        getQueryOptions().add(new QueryOption("$expand", value));
        return (UserActivityReferenceRequest)this;
    }
    /**
     * Puts the UserActivity
     *
     * @param srcUserActivity the UserActivity reference to PUT
     * @param callback the callback to be called after success or failure
     */
    public void put(UserActivity srcUserActivity, final ICallback<UserActivity> callback) {
        send(HttpMethod.PUT, callback, srcUserActivity);
    }

    /**
     * Puts the UserActivity
     *
     * @param srcUserActivity the UserActivity reference to PUT
     * @return the UserActivity
     * @throws ClientException an exception occurs if there was an error while the request was sent
     */
    public UserActivity put(UserActivity srcUserActivity) throws ClientException {
        return send(HttpMethod.PUT, srcUserActivity);
    }
}
