// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.models.extensions.ConditionalAccessPolicy;
import com.microsoft.graph.models.extensions.NamedLocation;
import com.microsoft.graph.models.extensions.Entity;
import com.microsoft.graph.requests.extensions.ConditionalAccessPolicyCollectionResponse;
import com.microsoft.graph.requests.extensions.ConditionalAccessPolicyCollectionPage;
import com.microsoft.graph.requests.extensions.NamedLocationCollectionResponse;
import com.microsoft.graph.requests.extensions.NamedLocationCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.JsonElement;
import com.google.gson.annotations.*;
import java.util.HashMap;
import java.util.Map;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Conditional Access Root.
 */
public class ConditionalAccessRoot extends Entity implements IJsonBackedObject {


    /**
     * The Policies.
     * 
     */
    public ConditionalAccessPolicyCollectionPage policies;

    /**
     * The Named Locations.
     * 
     */
    public NamedLocationCollectionPage namedLocations;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;


        if (json.has("policies")) {
            final ConditionalAccessPolicyCollectionResponse response = new ConditionalAccessPolicyCollectionResponse();
            if (json.has("policies@odata.nextLink")) {
                response.nextLink = json.get("policies@odata.nextLink").getAsString();
            }

            final JsonObject[] sourceArray = serializer.deserializeObject(json.get("policies").toString(), JsonObject[].class);
            final ConditionalAccessPolicy[] array = new ConditionalAccessPolicy[sourceArray.length];
            for (int i = 0; i < sourceArray.length; i++) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), ConditionalAccessPolicy.class);
                array[i].setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            policies = new ConditionalAccessPolicyCollectionPage(response, null);
        }

        if (json.has("namedLocations")) {
            final NamedLocationCollectionResponse response = new NamedLocationCollectionResponse();
            if (json.has("namedLocations@odata.nextLink")) {
                response.nextLink = json.get("namedLocations@odata.nextLink").getAsString();
            }

            final JsonObject[] sourceArray = serializer.deserializeObject(json.get("namedLocations").toString(), JsonObject[].class);
            final NamedLocation[] array = new NamedLocation[sourceArray.length];
            for (int i = 0; i < sourceArray.length; i++) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), NamedLocation.class);
                array[i].setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            namedLocations = new NamedLocationCollectionPage(response, null);
        }
    }
}
