// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Activity Based Timeout Policy Collection Request.
 */
public class ActivityBasedTimeoutPolicyCollectionRequest extends BaseCollectionRequest<ActivityBasedTimeoutPolicyCollectionResponse, IActivityBasedTimeoutPolicyCollectionPage> implements IActivityBasedTimeoutPolicyCollectionRequest {

    /**
     * The request builder for this collection of ActivityBasedTimeoutPolicy
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ActivityBasedTimeoutPolicyCollectionRequest(final String requestUrl, IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ActivityBasedTimeoutPolicyCollectionResponse.class, IActivityBasedTimeoutPolicyCollectionPage.class);
    }

    public void get(final ICallback<IActivityBasedTimeoutPolicyCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public IActivityBasedTimeoutPolicyCollectionPage get() throws ClientException {
        final ActivityBasedTimeoutPolicyCollectionResponse response = send();
        return buildFromResponse(response);
    }

    public void post(final ActivityBasedTimeoutPolicy newActivityBasedTimeoutPolicy, final ICallback<ActivityBasedTimeoutPolicy> callback) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        new ActivityBasedTimeoutPolicyRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newActivityBasedTimeoutPolicy, callback);
    }

    public ActivityBasedTimeoutPolicy post(final ActivityBasedTimeoutPolicy newActivityBasedTimeoutPolicy) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new ActivityBasedTimeoutPolicyRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newActivityBasedTimeoutPolicy);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public IActivityBasedTimeoutPolicyCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("$expand", value));
        return (ActivityBasedTimeoutPolicyCollectionRequest)this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public IActivityBasedTimeoutPolicyCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("$select", value));
        return (ActivityBasedTimeoutPolicyCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value the max number of items to return
     * @return the updated request
     */
    public IActivityBasedTimeoutPolicyCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("$top", value + ""));
        return (ActivityBasedTimeoutPolicyCollectionRequest)this;
    }

    public IActivityBasedTimeoutPolicyCollectionPage buildFromResponse(final ActivityBasedTimeoutPolicyCollectionResponse response) {
        final IActivityBasedTimeoutPolicyCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new ActivityBasedTimeoutPolicyCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final ActivityBasedTimeoutPolicyCollectionPage page = new ActivityBasedTimeoutPolicyCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
