// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Calendar Get Schedule Collection Request Builder.
 */
public class CalendarGetScheduleCollectionRequestBuilder extends BaseActionRequestBuilder implements ICalendarGetScheduleCollectionRequestBuilder {

    /**
     * The request builder for this collection of Calendar
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param schedules the schedules
     * @param endTime the endTime
     * @param startTime the startTime
     * @param availabilityViewInterval the availabilityViewInterval
     */
    public CalendarGetScheduleCollectionRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions, final java.util.List<String> schedules, final DateTimeTimeZone endTime, final DateTimeTimeZone startTime, final Integer availabilityViewInterval) {
        super(requestUrl, client, requestOptions);
  	 if(schedules!=null){
			bodyParams.put("schedules", schedules);
		}
    	 if(endTime!=null){
			bodyParams.put("endTime", endTime);
		}
    	 if(startTime!=null){
			bodyParams.put("startTime", startTime);
		}
    	 if(availabilityViewInterval!=null){
			bodyParams.put("availabilityViewInterval", availabilityViewInterval);
		}
      }

    public ICalendarGetScheduleCollectionRequest buildRequest() {
        return buildRequest(getOptions());
    }

    public ICalendarGetScheduleCollectionRequest buildRequest(final java.util.List<? extends Option> requestOptions) {
        CalendarGetScheduleCollectionRequest request = new CalendarGetScheduleCollectionRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("schedules")) {
            request.body.schedules = getParameter("schedules");
        }
        if (hasParameter("endTime")) {
            request.body.endTime = getParameter("endTime");
        }
        if (hasParameter("startTime")) {
            request.body.startTime = getParameter("startTime");
        }
        if (hasParameter("availabilityViewInterval")) {
            request.body.availabilityViewInterval = getParameter("availabilityViewInterval");
        }
  
        return request;
    }
}
