// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.ICallUpdateRecordingStatusRequest;
import com.microsoft.graph.requests.extensions.CallUpdateRecordingStatusRequest;
import com.microsoft.graph.models.generated.RecordingStatus;

import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.BaseFunctionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.FunctionOption;
import com.google.gson.JsonElement;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Call Update Recording Status Request Builder.
 */
public class CallUpdateRecordingStatusRequestBuilder extends BaseActionRequestBuilder implements ICallUpdateRecordingStatusRequestBuilder {

    /**
     * The request builder for this CallUpdateRecordingStatus
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param status the status
     * @param clientContext the clientContext
     */
    public CallUpdateRecordingStatusRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions, final RecordingStatus status, final String clientContext) {
        super(requestUrl, client, requestOptions);
        bodyParams.put("status", status);
        bodyParams.put("clientContext", clientContext);
    }

    /**
     * Creates the ICallUpdateRecordingStatusRequest
     *
     * @return the ICallUpdateRecordingStatusRequest instance
     */
    public ICallUpdateRecordingStatusRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the ICallUpdateRecordingStatusRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the ICallUpdateRecordingStatusRequest instance
     */
    public ICallUpdateRecordingStatusRequest buildRequest(final java.util.List<? extends Option> requestOptions) {
        CallUpdateRecordingStatusRequest request = new CallUpdateRecordingStatusRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("status")) {
            request.body.status = getParameter("status");
        }

        if (hasParameter("clientContext")) {
            request.body.clientContext = getParameter("clientContext");
        }

        return request;
    }
}
