// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IDetectedAppRequest;
import com.microsoft.graph.requests.extensions.DetectedAppRequest;
import com.microsoft.graph.requests.extensions.IManagedDeviceCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.extensions.ManagedDeviceCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.extensions.IManagedDeviceWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.ManagedDeviceWithReferenceRequestBuilder;

import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.options.Option;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Detected App Request Builder.
 */
public class DetectedAppRequestBuilder extends BaseRequestBuilder implements IDetectedAppRequestBuilder {

    /**
     * The request builder for the DetectedApp
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public DetectedAppRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @return the IDetectedAppRequest instance
     */
    public IDetectedAppRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the IDetectedAppRequest instance
     */
    public IDetectedAppRequest buildRequest(final java.util.List<? extends Option> requestOptions) {
        return new DetectedAppRequest(getRequestUrl(), getClient(), requestOptions);
    }


    public IManagedDeviceCollectionWithReferencesRequestBuilder managedDevices() {
        return new ManagedDeviceCollectionWithReferencesRequestBuilder(getRequestUrlWithAdditionalSegment("managedDevices"), getClient(), null);
    }

    public IManagedDeviceWithReferenceRequestBuilder managedDevices(final String id) {
        return new ManagedDeviceWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("managedDevices") + "/" + id, getClient(), null);
    }
}

