// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.Application;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Application Request.
 */
public interface IApplicationRequest extends IHttpRequest {

    /**
     * Gets the Application from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<Application> callback);

    /**
     * Gets the Application from the service
     *
     * @return the Application from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Application get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<Application> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this Application with a source
     *
     * @param sourceApplication the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final Application sourceApplication, final ICallback<Application> callback);

    /**
     * Patches this Application with a source
     *
     * @param sourceApplication the source object with updates
     * @return the updated Application
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Application patch(final Application sourceApplication) throws ClientException;

    /**
     * Posts a Application with a new object
     *
     * @param newApplication the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final Application newApplication, final ICallback<Application> callback);

    /**
     * Posts a Application with a new object
     *
     * @param newApplication the new object to create
     * @return the created Application
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Application post(final Application newApplication) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IApplicationRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IApplicationRequest expand(final String value);

}

