// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.IdentityContainer;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Identity Container Request.
 */
public interface IIdentityContainerRequest extends IHttpRequest {

    /**
     * Gets the IdentityContainer from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<IdentityContainer> callback);

    /**
     * Gets the IdentityContainer from the service
     *
     * @return the IdentityContainer from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    IdentityContainer get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<IdentityContainer> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this IdentityContainer with a source
     *
     * @param sourceIdentityContainer the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final IdentityContainer sourceIdentityContainer, final ICallback<IdentityContainer> callback);

    /**
     * Patches this IdentityContainer with a source
     *
     * @param sourceIdentityContainer the source object with updates
     * @return the updated IdentityContainer
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    IdentityContainer patch(final IdentityContainer sourceIdentityContainer) throws ClientException;

    /**
     * Posts a IdentityContainer with a new object
     *
     * @param newIdentityContainer the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final IdentityContainer newIdentityContainer, final ICallback<IdentityContainer> callback);

    /**
     * Posts a IdentityContainer with a new object
     *
     * @param newIdentityContainer the new object to create
     * @return the created IdentityContainer
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    IdentityContainer post(final IdentityContainer newIdentityContainer) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IIdentityContainerRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IIdentityContainerRequest expand(final String value);

}

