// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.Shift;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Shift Request.
 */
public interface IShiftRequest extends IHttpRequest {

    /**
     * Gets the Shift from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<Shift> callback);

    /**
     * Gets the Shift from the service
     *
     * @return the Shift from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Shift get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<Shift> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this Shift with a source
     *
     * @param sourceShift the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final Shift sourceShift, final ICallback<Shift> callback);

    /**
     * Patches this Shift with a source
     *
     * @param sourceShift the source object with updates
     * @return the updated Shift
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Shift patch(final Shift sourceShift) throws ClientException;

    /**
     * Posts a Shift with a new object
     *
     * @param newShift the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final Shift newShift, final ICallback<Shift> callback);

    /**
     * Posts a Shift with a new object
     *
     * @param newShift the new object to create
     * @return the created Shift
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Shift post(final Shift newShift) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IShiftRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IShiftRequest expand(final String value);

}

