// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Named Location Collection Request.
 */
public class NamedLocationCollectionRequest extends BaseCollectionRequest<NamedLocationCollectionResponse, INamedLocationCollectionPage> implements INamedLocationCollectionRequest {

    /**
     * The request builder for this collection of NamedLocation
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public NamedLocationCollectionRequest(final String requestUrl, IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, NamedLocationCollectionResponse.class, INamedLocationCollectionPage.class);
    }

    public void get(final ICallback<INamedLocationCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public INamedLocationCollectionPage get() throws ClientException {
        final NamedLocationCollectionResponse response = send();
        return buildFromResponse(response);
    }

    public void post(final NamedLocation newNamedLocation, final ICallback<NamedLocation> callback) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        new NamedLocationRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newNamedLocation, callback);
    }

    public NamedLocation post(final NamedLocation newNamedLocation) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new NamedLocationRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newNamedLocation);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public INamedLocationCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("$expand", value));
        return (NamedLocationCollectionRequest)this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public INamedLocationCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("$select", value));
        return (NamedLocationCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value the max number of items to return
     * @return the updated request
     */
    public INamedLocationCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("$top", value + ""));
        return (NamedLocationCollectionRequest)this;
    }

    public INamedLocationCollectionPage buildFromResponse(final NamedLocationCollectionResponse response) {
        final INamedLocationCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new NamedLocationCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final NamedLocationCollectionPage page = new NamedLocationCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
