// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IOpenShiftChangeRequestRequest;
import com.microsoft.graph.requests.extensions.OpenShiftChangeRequestRequest;
import com.microsoft.graph.models.extensions.OpenShiftChangeRequest;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Open Shift Change Request Request.
 */
public class OpenShiftChangeRequestRequest extends BaseRequest implements IOpenShiftChangeRequestRequest {
	
    /**
     * The request for the OpenShiftChangeRequest
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public OpenShiftChangeRequestRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, OpenShiftChangeRequest.class);
    }

    /**
     * Gets the OpenShiftChangeRequest from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<OpenShiftChangeRequest> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the OpenShiftChangeRequest from the service
     *
     * @return the OpenShiftChangeRequest from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public OpenShiftChangeRequest get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<OpenShiftChangeRequest> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this OpenShiftChangeRequest with a source
     *
     * @param sourceOpenShiftChangeRequest the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final OpenShiftChangeRequest sourceOpenShiftChangeRequest, final ICallback<OpenShiftChangeRequest> callback) {
        send(HttpMethod.PATCH, callback, sourceOpenShiftChangeRequest);
    }

    /**
     * Patches this OpenShiftChangeRequest with a source
     *
     * @param sourceOpenShiftChangeRequest the source object with updates
     * @return the updated OpenShiftChangeRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public OpenShiftChangeRequest patch(final OpenShiftChangeRequest sourceOpenShiftChangeRequest) throws ClientException {
        return send(HttpMethod.PATCH, sourceOpenShiftChangeRequest);
    }

    /**
     * Creates a OpenShiftChangeRequest with a new object
     *
     * @param newOpenShiftChangeRequest the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final OpenShiftChangeRequest newOpenShiftChangeRequest, final ICallback<OpenShiftChangeRequest> callback) {
        send(HttpMethod.POST, callback, newOpenShiftChangeRequest);
    }

    /**
     * Creates a OpenShiftChangeRequest with a new object
     *
     * @param newOpenShiftChangeRequest the new object to create
     * @return the created OpenShiftChangeRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public OpenShiftChangeRequest post(final OpenShiftChangeRequest newOpenShiftChangeRequest) throws ClientException {
        return send(HttpMethod.POST, newOpenShiftChangeRequest);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public IOpenShiftChangeRequestRequest select(final String value) {
         getQueryOptions().add(new QueryOption("$select", value));
         return (OpenShiftChangeRequestRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public IOpenShiftChangeRequestRequest expand(final String value) {
         getQueryOptions().add(new QueryOption("$expand", value));
         return (OpenShiftChangeRequestRequest)this;
     }

}

