// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Site Reference Request.
 */
public class SiteReferenceRequest extends BaseRequest implements ISiteReferenceRequest {

    /**
     * The request for the Site
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public SiteReferenceRequest(String requestUrl, IBaseClient client, java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Site.class);
    }

    public void delete(final ICallback<Site> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    public Site delete() throws ClientException {
       return send(HttpMethod.DELETE, null);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public ISiteReferenceRequest select(final String value) {
        getQueryOptions().add(new QueryOption("$select", value));
        return (SiteReferenceRequest)this;
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public ISiteReferenceRequest expand(final String value) {
        getQueryOptions().add(new QueryOption("$expand", value));
        return (SiteReferenceRequest)this;
    }
    /**
     * Puts the Site
     *
     * @param srcSite the Site reference to PUT
     * @param callback the callback to be called after success or failure
     */
    public void put(Site srcSite, final ICallback<Site> callback) {
        send(HttpMethod.PUT, callback, srcSite);
    }

    /**
     * Puts the Site
     *
     * @param srcSite the Site reference to PUT
     * @return the Site
     * @throws ClientException an exception occurs if there was an error while the request was sent
     */
    public Site put(Site srcSite) throws ClientException {
        return send(HttpMethod.PUT, srcSite);
    }
}
