// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IWorkbookWorksheetProtectionRequest;
import com.microsoft.graph.requests.extensions.WorkbookWorksheetProtectionRequest;
import com.microsoft.graph.models.extensions.WorkbookWorksheetProtectionOptions;
import com.microsoft.graph.requests.extensions.IWorkbookWorksheetProtectionProtectRequestBuilder;
import com.microsoft.graph.requests.extensions.WorkbookWorksheetProtectionProtectRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookWorksheetProtectionUnprotectRequestBuilder;
import com.microsoft.graph.requests.extensions.WorkbookWorksheetProtectionUnprotectRequestBuilder;

import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.options.Option;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Worksheet Protection Request Builder.
 */
public class WorkbookWorksheetProtectionRequestBuilder extends BaseRequestBuilder implements IWorkbookWorksheetProtectionRequestBuilder {

    /**
     * The request builder for the WorkbookWorksheetProtection
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WorkbookWorksheetProtectionRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @return the IWorkbookWorksheetProtectionRequest instance
     */
    public IWorkbookWorksheetProtectionRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the IWorkbookWorksheetProtectionRequest instance
     */
    public IWorkbookWorksheetProtectionRequest buildRequest(final java.util.List<? extends Option> requestOptions) {
        return new WorkbookWorksheetProtectionRequest(getRequestUrl(), getClient(), requestOptions);
    }



    public IWorkbookWorksheetProtectionProtectRequestBuilder protect(final WorkbookWorksheetProtectionOptions options) {
        return new WorkbookWorksheetProtectionProtectRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.protect"), getClient(), null, options);
    }

    public IWorkbookWorksheetProtectionUnprotectRequestBuilder unprotect() {
        return new WorkbookWorksheetProtectionUnprotectRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.unprotect"), getClient(), null);
    }
}

