// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.models.generated.AppliedConditionalAccessPolicyResult;


import com.google.gson.JsonObject;
import com.google.gson.JsonElement;
import com.google.gson.annotations.*;
import java.util.HashMap;
import java.util.Map;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Applied Conditional Access Policy.
 */
public class AppliedConditionalAccessPolicy implements IJsonBackedObject {

    @SerializedName("@odata.type")
    @Expose
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Id.
     * Unique GUID of the conditional access policy.
     */
    @SerializedName("id")
    @Expose
    public String id;

    /**
     * The Display Name.
     * Refers to the Name of the conditional access policy (example: 'Require MFA for Salesforce').
     */
    @SerializedName("displayName")
    @Expose
    public String displayName;

    /**
     * The Enforced Grant Controls.
     * Refers to the grant controls enforced by the conditional access policy (example: 'Require multi-factor authentication').
     */
    @SerializedName("enforcedGrantControls")
    @Expose
    public java.util.List<String> enforcedGrantControls;

    /**
     * The Enforced Session Controls.
     * Refers to the session controls enforced by the conditional access policy (example: 'Require app enforced controls').
     */
    @SerializedName("enforcedSessionControls")
    @Expose
    public java.util.List<String> enforcedSessionControls;

    /**
     * The Result.
     * Indicates the result of the CA policy that was triggered. Possible values are:successfailurenotApplied - Policy isn't applied because policy conditions were not met.notEnabled - This is due to the policy in disabled state.
     */
    @SerializedName("result")
    @Expose
    public AppliedConditionalAccessPolicyResult result;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;

    }
}
