// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.models.generated.ChangeType;
import com.microsoft.graph.models.extensions.ResourceData;


import com.google.gson.JsonObject;
import com.google.gson.JsonElement;
import com.google.gson.annotations.*;
import java.util.HashMap;
import java.util.Map;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Change Notification.
 */
public class ChangeNotification implements IJsonBackedObject {

    @SerializedName("@odata.type")
    @Expose
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Id.
     * Unique ID for the notification. Optional.
     */
    @SerializedName("id")
    @Expose
    public String id;

    /**
     * The Subscription Id.
     * The unique identifier of the subscription that generated the notification.
     */
    @SerializedName("subscriptionId")
    @Expose
    public java.util.UUID subscriptionId;

    /**
     * The Subscription Expiration Date Time.
     * The expiration time for the subscription. Required.
     */
    @SerializedName("subscriptionExpirationDateTime")
    @Expose
    public java.util.Calendar subscriptionExpirationDateTime;

    /**
     * The Client State.
     * Value of the clientState property sent in the subscription request (if any). The maximum length is 255 characters. The client can check whether the change notification came from the service by comparing the values of the clientState property. The value of the clientState property sent with the subscription is compared with the value of the clientState property received with each change notification. Optional.
     */
    @SerializedName("clientState")
    @Expose
    public String clientState;

    /**
     * The Change Type.
     * Indicates the type of change that will raise the change notification. The supported values are: created, updated, deleted. Required.
     */
    @SerializedName("changeType")
    @Expose
    public ChangeType changeType;

    /**
     * The Resource.
     * The URI of the resource that emitted the change notification relative to https://graph.microsoft.com. Required.
     */
    @SerializedName("resource")
    @Expose
    public String resource;

    /**
     * The Tenant Id.
     * The unique identifier of the tenant from which the change notification originated.
     */
    @SerializedName("tenantId")
    @Expose
    public java.util.UUID tenantId;

    /**
     * The Resource Data.
     * The content of this property depends on the type of resource being subscribed to. Required.
     */
    @SerializedName("resourceData")
    @Expose
    public ResourceData resourceData;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;

    }
}
